package com.floreantpos.report.model;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class PaymentReceivedReportModel extends ListTableModel {
	public PaymentReceivedReportModel() {
		super(new String[] { "user", "transTime", "transNo", "ticket", "transType", "total", "memberName", "orderDate", "type", "revertReason", "voidedTime", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$
				"transBy" });

	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction data = (PosTransaction) rows.get(rowIndex);
		Ticket ticket = data.getTicket();
		switch (columnIndex) {
			case 0:
				return data.getVoidedByUser();

			case 1:
				return DateUtil.formatReportDateWithBrowserTimeOffset(data.getTransactionTime());

			case 2:
				return data.getId();

			case 3:
				return data.getEntityNoDisplay();

			case 4:
				PaymentType paymentType = data.getPaymentType();
				if (paymentType == null) {
					return null;
				}
				String paymentTypeStr;
				if (paymentType.equals(PaymentType.CUSTOM_PAYMENT)) {
					String customPaymentName = data.getCustomPaymentName();
					paymentTypeStr = StringUtils.isEmpty(customPaymentName) ? null : customPaymentName;
				}
				else if (paymentType.equals(PaymentType.BANK_ACCOUNT)) {
					String bankAccountDisplayName = data.getBankAccountDisplay();
					paymentTypeStr = StringUtils.isEmpty(bankAccountDisplayName) ? null : bankAccountDisplayName;
				}
				else {
					paymentTypeStr = paymentType.getDisplayString();
				}
				return paymentTypeStr;

			case 5:
				if (data.getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
					return NumberUtil.round((-1) * data.getAmount());
				}
				return NumberUtil.round(data.getAmount());

			case 6:
				if (ticket == null) {
					return ""; //$NON-NLS-1$
				}
				if (data.getTicket().getCustomer() != null) {
					return data.getTicket().getCustomer().getName();
				}
				else {
					return ""; //$NON-NLS-1$
				}

			case 7:
				if (ticket != null) {
					return DateUtil.formatDateWithBrowserTimeOffset(ticket.getCreateDate());
				}
				return StringUtils.EMPTY;

			case 8:
				return data.getType();

			case 9:
				return data.getRevertReason();

			case 10:
				Date voidDate = data.getVoidDate();
				if (voidDate == null) {
					return StringUtils.EMPTY;
				}
				return DateUtil.formatReportDateWithBrowserTimeOffset(voidDate);

			case 11:
				return data.getUserName();
		}
		return null;
	}

}