package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.Address;
import com.floreantpos.model.AddressType;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class AddressDAO extends BaseAddressDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public AddressDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public Address findAddressById(String addressId) {
		Session session = null;

		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Address.PROP_ID, addressId));

			Object result = criteria.uniqueResult();
			if (result != null) {
				return (Address) result;
			}
			else {
				return null;

			}
		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

	public void saveOrUpdateAddressList(List<Address> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			for (Iterator iterator = dataList.iterator(); iterator.hasNext();) {
				Address item = (Address) iterator.next();
				if (item.getId() == null) {
					save(item, session);
				}
				else {
					Address existingItem = get(item.getId());
					if (existingItem != null) {
						if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
							PosLog.info(getClass(), item.getName() + " already updated"); //$NON-NLS-1$
							continue;
						}
						long version = existingItem.getVersion();
						PropertyUtils.copyProperties(existingItem, item);
						existingItem.setVersion(version);
						existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
						existingItem.setUpdateSyncTime(updateSyncTime);
						update(existingItem, session);
					}
					else {
						item.setVersion(0);
						item.setUpdateLastUpdateTime(updateLastUpdateTime);
						item.setUpdateSyncTime(updateSyncTime);
						save(item, session);
					}
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}
	}

	public List<Address> findAllAddress(AddressType addressType) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Address.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Address.PROP_TYPE, addressType.name()));
			criteria.addOrder(Order.asc(Address.PROP_NAME).ignoreCase());
			return criteria.list();
		}
	}

}