package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.DischargeRecord;

public class DischargeRecordDAO extends BaseDischargeRecordDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public DischargeRecordDAO() {
	}

	public DischargeRecord findByBookingId(String admissionId) {
		if (StringUtils.isEmpty(admissionId)) {
			return null;
		}
		try (Session session = this.createNewSession()) {
			return findByBookingId(admissionId, session);
		}
	}

	public DischargeRecord findByBookingId(String admissionId, Session session) {
		Criteria criteria = session.createCriteria(DischargeRecord.class);
		this.addDeletedFilter(criteria);
		criteria.add(Restrictions.eq(DischargeRecord.PROP_ADMISSION_ID, admissionId));
		return (DischargeRecord) criteria.uniqueResult();
	}

}