package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BasePatientAllergy;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class PatientAllergy extends BasePatientAllergy implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PatientAllergy() {
	}

	/**
	 * Constructor for primary key
	 */
	public PatientAllergy(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public String getAllergyName() {
		String allergyName = getProperty("allergyName"); //$NON-NLS-1$
		if (StringUtils.isNotBlank(allergyName)) {
			return allergyName;
		}

		String allergyId = getAllergyId();
		if (StringUtils.isBlank(allergyId)) {
			return StringUtils.EMPTY;
		}

		Allergy allergy = (Allergy) DataProvider.get().getObjectOf(Allergy.class, allergyId);
		if (allergy == null) {
			return StringUtils.EMPTY;
		}

		allergyName = allergy.getName();
		putAllergyName(allergyName);
		return allergyName;
	}

	public void putAllergyName(String name) {
		addProperty("allergyName", name); //$NON-NLS-1$
	}
}