package com.floreantpos.model;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import com.floreantpos.model.dao.PayoutSubReasonDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "paymentType", "balanceType" })
@XmlRootElement
public class BalanceUpdateTransaction extends BaseBalanceUpdateTransaction implements TimedModel, PropertyContainer {

	private static final long serialVersionUID = 1L;

	public static final String JSON_PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static final String JSON_PROP_BALANCE_BEFORE = "balance.before"; //$NON-NLS-1$
	public static final String DEPOSIT_FROM_ID = "depositFromId";
	public static final String DEPOSIT_FROM_NAME = "depositFromName";

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	private transient Project project;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BalanceUpdateTransaction() {
	}

	/**
	 * Constructor for primary key
	 */
	public BalanceUpdateTransaction(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public BalanceUpdateTransaction(java.lang.String id, java.lang.String balanceTypeString, java.lang.String paymentTypeString,
			java.lang.String transactionType, java.lang.String transactionSubType) {

		super(id, balanceTypeString, paymentTypeString, transactionType, transactionSubType);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setPaymentType(PaymentType paymentType) {
		setPaymentTypeString(paymentType != null ? paymentType.name() : null);
	}

	@XmlTransient
	public PaymentType getPaymentType() {
		String paymentTypeString = super.getPaymentTypeString();
		if (paymentTypeString == null) {
			return null;
		}
		return PaymentType.valueOf(paymentTypeString);
	}

	public void setBalanceType(BalanceType balanceType) {
		setBalanceTypeString(balanceType != null ? balanceType.name() : null);
	}

	@XmlTransient
	public BalanceType getBalanceType() {
		String balanceTypeString = super.getBalanceTypeString();
		if (balanceTypeString == null) {
			return null;
		}
		return BalanceType.fromString(balanceTypeString);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public String getDescriptionDisplay() {
		String description = getDescription();

		//		String userId = getSalaryPaidTo();
		//		if (StringUtils.isNotBlank(userId)) {
		//			User user = DataProvider.get().getUserById(userId, getOutletId());
		//			if (user != null) {
		//				description += (StringUtils.isBlank(description) ? StringUtils.EMPTY : ". ") + "Employee: " + user.getFullName();
		//			}
		//		}
		//
		//		String customePaymentInfoDisplay = getCustomePaymentInfoDisplay();
		//		if (StringUtils.isNotBlank(customePaymentInfoDisplay)) {
		//			description += (StringUtils.isBlank(description) ? StringUtils.EMPTY : ". ") + customePaymentInfoDisplay;
		//		}

		return description;
	}

	public String getDescription() {
		return getProperty(JSON_PROP_DESCRIPTION, "");
	}

	public void setDescription(String details) {
		addProperty(JSON_PROP_DESCRIPTION, details);
	}

	public Double getBalanceBefore() {
		return POSUtil.parseDouble(getProperty(JSON_PROP_BALANCE_BEFORE));
	}

	public void setBalanceBefore(double amount) {
		addProperty(JSON_PROP_BALANCE_BEFORE, String.valueOf(amount));
	}

	public String getCustomerName() {
		Customer customer = DataProvider.get().getCustomer(getAccountNumber());
		return customer == null ? "" : customer.getName();
	}

	public void putCustomerName() {

	}

	public String getCustomPaymnetId() {
		return getProperty("custom.paymnet.id", "");
	}

	public void setCustomPaymnetId(String customPaymnetId) {
		addProperty("custom.paymnet.id", customPaymnetId);
	}

	public String getCustomPaymnetRef() {
		return getProperty("custom.paymnet.ref", "");
	}

	public void setCustomPaymnetRef(String customPaymnetRef) {
		addProperty("custom.paymnet.ref", customPaymnetRef);
	}

	public String getPaymentTypeDisplayString() {
		PaymentType paymentType = getPaymentType();
		if (paymentType == PaymentType.CUSTOM_PAYMENT) {
			String customPaymnetId = getCustomPaymnetId();
			CustomPayment customPayment = DataProvider.get().getCustomPaymentById(customPaymnetId, getOutletId());
			if (customPayment != null) {
				return customPayment.getName();
			}
		}
		else if (paymentType == PaymentType.BANK_ACCOUNT) {
			return getBankAccountDisplay();
		}
		return paymentType.getDisplayString();
	}

	public String getBankAccountDisplay() {
		String bankAccountId = getBankAccountId();
		if (StringUtils.isNotBlank(bankAccountId)) {
			BankAccount bankAccount = (BankAccount) DataProvider.get().getObjectOf(BankAccount.class, bankAccountId);
			if (bankAccount != null) {
				return bankAccount.getDisplayString();
			}
		}
		return bankAccountId;

	}

	public String getEventTimeDisplay() {
		Date eventTime = getEventTime();
		return eventTime == null ? StringUtils.EMPTY : DateUtil.formatReportShortDateWithBrowserTimeOffset(eventTime);
	}

	public String getTransactionTimeDisplay() {
		if (this instanceof BalanceForwardTransaction) {
			return "Balance forward"; //$NON-NLS-1$
		}
		Date startTime = getTransactionTime();
		return startTime == null ? StringUtils.EMPTY : DateUtil.formatReportDateWithBrowserTimeOffset(startTime);
	}

	public String getAccountManager() {
		if (this instanceof BalanceForwardTransaction) {
			return "Balance forward";
		}

		if (this instanceof EndBalanceTransaction) {
			return "End Balance";
		}

		String userId = getAccountNumber();
		if (StringUtils.isNotBlank(userId)) {
			if (DataProvider.get().getStore().getId().equals(userId)) {
				return "Store";
			}

			User user = DataProvider.get().getUserById(userId, getOutletId());
			if (user != null) {
				return user.getFullName();
			}
		}
		return StringUtils.EMPTY;
	}

	public String getRecepientDisplay() {
		if (TransactionType.CREDIT.name().equals(getTransactionType())) {
			if ((BalanceType.ACCOUNTS_MANAGER_BALANCE.name()).equals(getBalanceTypeString())) {
				return getAccountManager();
			}
		}
		if (((BalanceSubType.TRANSFER_OUT.name()).equals(getTransactionSubType()))) {
			return "Store"; //$NON-NLS-1$
		}

		String recepientId = getRecepientId();
		if (StringUtils.isNotBlank(recepientId)) {
			PayoutRecepient recepient = PayoutRecepientDAO.getInstance().get(recepientId);
			return recepient != null ? recepient.getName() : StringUtils.EMPTY;
		}

		String vendorId = getVendorId();
		if (StringUtils.isNotBlank(vendorId)) {
			InventoryVendor vendor = (InventoryVendor) DataProvider.get().getObjectOf(InventoryVendor.class, vendorId);
			return vendor != null ? vendor.getName() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getReasonDisplay() {
		if (this instanceof BalanceForwardTransaction) {
			return StringUtils.EMPTY;
		}

		String reasonId = getReasonId();
		if (StringUtils.isEmpty(reasonId)) {
			String transactionSubType = this.getTransactionSubType();
			if (TransactionType.CREDIT.name().equals(this.getTransactionType())) {
				if (BalanceSubType.EXPENSE_REFUND.name().equals(transactionSubType)) {
					return "Cash refund"; //$NON-NLS-1$
				}
				if (BalanceSubType.EXPENSE_REVERT.name().equals(transactionSubType)) {
					return "Cash revert"; //$NON-NLS-1$
				}
				return "Cash in"; //$NON-NLS-1$
			}

			if (((BalanceSubType.TRANSFER_OUT.name()).equals(transactionSubType))) {
				return "Transfer out"; //$NON-NLS-1$
			}

		}
		else {
			PayoutReason payoutReason = PayoutReasonDAO.getInstance().get(reasonId);
			return payoutReason != null ? payoutReason.getReason() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getSubCategoryDisplay() {
		String subReasonId = getSubReasonId();
		if (StringUtils.isNotEmpty(subReasonId)) {
			PayoutSubReason subPayoutReason = PayoutSubReasonDAO.getInstance().get(subReasonId);
			return subPayoutReason != null ? subPayoutReason.getReason() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getProjectDisplay() {
		String projectId = getProjectId();
		if (StringUtils.isNotEmpty(projectId)) {
			Project project = ProjectDAO.getInstance().get(projectId);
			return project != null ? project.getName() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public Double getExpenseAmountDisplay() {
		if (getAmount() == 0) {
			return 0d;
		}
		if (getTransactionType().equals(TransactionType.CREDIT.name())) {
			return getAmount() * (-1);
		}
		return Math.abs(getAmount());
	}

	public void putPerformer(User performer) {
		if (performer == null) {
			setPerformerId(null);
			putPerformerOutletId(null);
			putPerformerName(null);
		}
		else {
			setPerformerId(performer.getId());
			putPerformerOutletId(performer.getOutletId());
			putPerformerName(performer.getFullName());
		}
	}

	public String getPerformerOutletId() {
		if (hasProperty("perform.by.outlet.id")) {
			return getProperty("perform.by.outlet.id", "");
		}
		return getOutletId();
	}

	public void putPerformerOutletId(String performBy) {
		addProperty("perform.by.outlet.id", performBy);
	}

	public String getPerformerName() {
		return getProperty("perform.by.name", "");
	}

	public void putPerformerName(String performByName) {
		addProperty("perform.by.name", performByName);
	}

	public String getPerformByDisplay() {
		String performerName = getPerformerName();
		if (StringUtils.isNotBlank(performerName)) {
			return performerName;
		}

		String performById = getPerformerId();
		if (StringUtils.isNotBlank(performById)) {
			User performBy = DataProvider.get().getUserById(performById, getPerformerOutletId());
			if (performBy != null) {
				return performBy.getFullName();
			}
		}
		return "";
	}

	public String getSalaryPaidTo() {
		return getProperty("user.salary_paid_to", "");
	}

	public void putSalaryPaidTo(String paidTo) {
		addProperty("user.salary_paid_to", paidTo);
	}

	/**
	 *  PosTransaction id
	 */
	public String getReferenceId() {
		return getProperty("reference_id", "");
	}

	/**
	 * @param referenceId
	 * 
	 * PosTransaction id
	 */
	public void putReferenceId(String referenceId) {
		addProperty("reference_id", referenceId);
	}

	//	/**
	//	 * @return
	//	 *  {@link BankAccount} id
	//	 */
	//	public String getBankAccountId() {
	//		return getProperty("bank_account_id", "");
	//	}
	//
	//	/**
	//	 * @param bankOrCustomPaymentId
	//	 * 
	//	 * {@link BankAccount} id
	//	 */
	//	public void putBankAccountId(String bankOrCustomPaymentId) {
	//		addProperty("bank_account_id", bankOrCustomPaymentId);
	//	}

	//	public String getMemoNo() {
	//		return getProperty("memo_no", ""); //$NON-NLS-1$
	//	}
	//
	//	public void putMemoNo(String memoNo) {
	//		addProperty("memo_no", memoNo); //$NON-NLS-1$
	//	}

	public String getMemoImageId() {
		return getProperty("memo_image_id"); //$NON-NLS-1$
	}

	public void putMemoImageId(String memoImageId) {
		addProperty("memo_image_id", memoImageId); //$NON-NLS-1$
	}

	public void putCustomePaymentInfo(String json) {
		addProperty("payment", json); //$NON-NLS-1$
	}

	public String getCustomePaymentInfo() {
		return getProperty("payment", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String getCustomePaymentInfoDisplay() {
		String paymentRefStr = getCustomePaymentInfo().replace("\"", StringUtils.EMPTY).replace(",", ", ").replace(":", " : ");

		if (paymentRefStr.startsWith("[{") && paymentRefStr.endsWith("}]")) {
			return paymentRefStr.substring(2, paymentRefStr.length() - 2);
		}
		else if (paymentRefStr.startsWith("[") && paymentRefStr.endsWith("]")) {
			return paymentRefStr.substring(1, paymentRefStr.length() - 1);
		}

		return paymentRefStr;
	}

	public String getTransactionReason() {
		if (this instanceof BalanceForwardTransaction) {
			return StringUtils.EMPTY;
		}

		String transactionReason = getProperty("transactionReason"); //$NON-NLS-1$
		if (StringUtils.isNotBlank(transactionReason)) {
			return transactionReason;
		}

		if (getTransactionType().equals(TransactionType.CREDIT.name())) {
			return "Add balance"; //$NON-NLS-1$
		}

		String userId = getSalaryPaidTo();
		if (StringUtils.isNotEmpty(userId)) {
			User user = DataProvider.get().getUserById(userId, getOutletId());
			return user != null ? user.getFullName() : StringUtils.EMPTY;
		}

		return StringUtils.EMPTY;
	}

	public void putTransactionReason(String reason) {
		addProperty("transactionReason", reason);
	}

	public void putBalanceTransferInfo(User fromUser, User toUser, double balance) {
		putBalanceTransferInfo(fromUser, toUser, balance, null);
	}

	public void putBalanceTransferInfo(User fromUser, User toUser, double balance, BankAccount bankAccount) {
		if (fromUser != null) {
			addProperty("balance_transfer.from_user_id", fromUser.getId());
			addProperty("balance_transfer.from_user_outlet_id", fromUser.getOutletId());
			addProperty("balance_transfer.from_user_name", fromUser.getFullName());
		}
		if (bankAccount != null) {
			addProperty("balance_transfer.from_bank_id", bankAccount.getId());
			addProperty("balance_transfer.from_bank_accountNo", bankAccount.getAccountNo());
			addProperty("balance_transfer.from_bank_name", bankAccount.getBankName());
			setBankAccount(bankAccount);
		}

		addProperty("balance_transfer.to_user_id", toUser.getId());
		addProperty("balance_transfer.to_user_outlet_id", toUser.getOutletId());
		addProperty("balance_transfer.to_user_name", toUser.getFullName());
		addProperty("balance_transfer.amount", NumberUtil.format(balance));
	}

	public String getOrderIdOrEmployeeId() {
		String orderId = getEntityNo();
		return StringUtils.isNotBlank(orderId) ? orderId
				: (StringUtils.isNotBlank(getTicketId()) ? getTicketId().equalsIgnoreCase("Balance forward") ? StringUtils.EMPTY : getTicketId() //$NON-NLS-1$
						: StringUtils.isNotBlank(getSalaryPaidTo()) ? getSalaryPaidTo() : getPerformerId());
	}

	public String getEntityNo() {
		return getProperty("entityNo");
	}

	public void putEntityNo(String entityNo) {
		addProperty("entityNo", entityNo);
	}

	public String getEntityId() {
		return getProperty("entityId");
	}

	public void putEntityId(String entityId) {
		addProperty("entityId", entityId);
	}

	public String getEntityType() {
		return getProperty("entityType");
	}

	public void putEntityType(String entityType) {
		addProperty("entityType", entityType);
	}

	public String getTransactionDescription() {
		return getTransactionDescription(false);
	}

	public String getTransactionDescription(boolean isStoreBalanceView) {
		if (this instanceof BalanceForwardTransaction || this instanceof EndBalanceTransaction) {
			return "";
		}

		String description = getDescription();

		boolean isBlankDescription = StringUtils.isBlank(description);
		if (isBlankDescription) {
			String fromCashdrawerId = getFromCashdrawerId();
			if (StringUtils.isNotBlank(fromCashdrawerId)) {
				return "Deposit from register " + fromCashdrawerId; //$NON-NLS-1$
			}

			String reasonId = getReasonId();
			if (StringUtils.isNotBlank(reasonId)) {
				PayoutReason reason = (PayoutReason) DataProvider.get().getObjectOf(PayoutReason.class, reasonId);
				if (reason != null) {
					description = reason.getReason();
					if (BalanceSubType.EXPENSE.name().equals(getTransactionSubType())) {
						boolean isBlank = StringUtils.isBlank(description);
						if (isBlank) {
							return "Expense";
						}
						return isStoreBalanceView ? "Expense: " + description : "Expense";
					}
				}
			}
		}
		String transactionSubType = getTransactionSubType();
		if (BalanceSubType.EXPENSE.name().equals(transactionSubType)) {
			if (isBlankDescription) {
				return "Expense";
			}
			return isStoreBalanceView ? "Expense: " + description : "Expense";
		}

		if (TransactionType.CREDIT.name().equals(getTransactionType())) {
			if (BalanceSubType.EXPENSE_REFUND.name().equals(transactionSubType)) {
				if (isBlankDescription) {
					return "Cash refund";
				}
				return isStoreBalanceView ? "Cash refund: " + description : "Cash refund";
			}

			if (BalanceSubType.EXPENSE_REVERT.name().equals(transactionSubType)) {
				if (isBlankDescription) {
					return "Cash revert";
				}
				return isStoreBalanceView ? "Cash revert: " + description : "Cash revert";
			}

			if (isBlankDescription) {
				return "Cash in";
			}
			return isStoreBalanceView ? "Cash in: " + description : "Cash in";
		}

		if ((BalanceSubType.TRANSFER_OUT.name()).equals(transactionSubType)) {
			description = "Transfer to store";
		}
		return description;
	}

	public String getRequisitionId() {
		return getProperty("requisition.id");
	}

	public void putRequisitionId(String requisitionId) {
		addProperty("requisition.id", requisitionId);
	}

	public String getSourceId() {
		return getProperty("source_id", "");
	}

	public void putSourceId(String sourceId) {
		addProperty("source_id", sourceId);
	}

	public String getSourceType() {
		return getProperty("source_type", "");
	}

	public void putSourceType(String sourceType) {
		addProperty("source_type", sourceType);
	}

	public String getVendorId() {
		return getProperty("vendor_id", "");
	}

	public void putVendorId(String vendorId) {
		addProperty("vendor_id", vendorId);
	}

	public void setProject(Project project) {
		this.project = project;
		if (project == null) {
			removeProperty("project_name");
			setProjectId(null);
		}
		else {
			addProperty("project_name", project.getName());
			setProjectId(project.getId());
		}
	}

	public Project getProject() {
		if (this.project != null) {
			return this.project;
		}
		String projectId = getProjectId();
		if (StringUtils.isNotBlank(projectId)) {
			this.project = (Project) DataProvider.get().getObjectOf(Project.class, projectId);
		}

		return this.project;
	}

	public void putCustomPaymentId(String customPaymentId) {
		addProperty("customPaymentId", customPaymentId);
	}

	public String getCustomPaymentId() {
		return getProperty("customPaymentId", "");
	}

	public void putCustomPaymentName(String customPaymentName) {
		addProperty("customPaymentName", customPaymentName);
	}

	public String getCustomPaymentName() {
		return getProperty("customPaymentName", "");
	}

	public void putCustomPaymentRef(String customPaymentRefJson) {
		addProperty("custom.payment.ref", customPaymentRefJson); //$NON-NLS-1$
	}

	public List getCustomPaymentRefJsonList() {
		String customPaymentRef = getProperty("custom.payment.ref", "[]"); //$NON-NLS-1$ //$NON-NLS-2$
		return new Gson().fromJson(customPaymentRef, List.class);
	}

	public void setBankAccount(BankAccount bankAccount) {
		if (bankAccount != null) {
			setBankAccountId(bankAccount.getId());
			addProperty("bank_account", bankAccount.getDisplayString());
		}
		else {
			setBankAccountId(null);
			removeProperty("bank_account");
		}
	}

	public String getNoteDisplay() {
		String note = getNote();
		if (StringUtils.isNotBlank(note)) {
			return note;
		}
		return "";
	}

	public String getNote() {
		return getProperty("note");
	}

	public void putNote(String note) {
		addProperty("note", note);
	}

	public String getDepositFromId() {
		return getProperty(DEPOSIT_FROM_ID);
	}

	public void putDepositFromId(String depositFromId) {
		addProperty(DEPOSIT_FROM_ID, depositFromId);
	}

	public String getDepositFromName() {
		return getProperty(DEPOSIT_FROM_NAME);
	}

	public void putDepositFromName(String depositFromName) {
		addProperty(DEPOSIT_FROM_NAME, depositFromName);
	}

	public String getGrantedByUserId() {
		return getProperty("grantedByUserId");
	}

	public void putGrantedByUserId(String id) {
		addProperty("grantedByUserId", id);
	}

	public String getGrantedByUserName() {
		return getProperty("grantedByUserName");
	}

	public void putGrantedByUserName(String userName) {
		addProperty("grantedByUserName", userName);
	}

	public String getPerformerNameDisplay() {
		String performerName = ""; //$NON-NLS-1$

		if (this instanceof EndBalanceTransaction) {
			return getTicketId();
		}

		String fromCashdrawerId = getFromCashdrawerId();
		if (StringUtils.isNotBlank(fromCashdrawerId)) {
			performerName = getPerformerName();
			if (StringUtils.isBlank(performerName)) {
				CashDrawer cashDrawer = CashDrawerDAO.getInstance().get(fromCashdrawerId);
				User assignedUser = cashDrawer.getAssignedUser();
				if (assignedUser != null) {
					performerName = assignedUser.getFullName();
				}
			}

		}
		else {
			String userId = getAccountNumber();
			if (StringUtils.isNotBlank(userId)) {
				User user = DataProvider.get().getUserById(userId, getOutletId());
				if (user != null) {
					performerName = user.getFullName();
				}
				else {
					String recepientId = getRecepientId();
					if (StringUtils.isNotBlank(recepientId)) {
						PayoutRecepient recepient = PayoutRecepientDAO.getInstance().get(recepientId);
						performerName = recepient != null ? recepient.getName() : StringUtils.EMPTY;
					}
				}
			}
		}

		return performerName;
	}
}