package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET_DISCOUNT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET_DISCOUNT"
 */

public abstract class BaseTicketDiscount  implements Comparable, Serializable {

	public static String REF = "TicketDiscount"; //$NON-NLS-1$
	public static String PROP_MINIMUM_AMOUNT = "minimumAmount"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public static String PROP_TOTAL_DISCOUNT_AMOUNT = "totalDiscountAmount"; //$NON-NLS-1$
	public static String PROP_VALUE = "value"; //$NON-NLS-1$
	public static String PROP_COUPON_QUANTITY = "couponQuantity"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_ID = "discountId"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_AUTO_APPLY = "autoApply"; //$NON-NLS-1$


	// constructors
	public BaseTicketDiscount () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTicketDiscount (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
		private java.lang.String discountId;
		private java.lang.String name;
		private java.lang.Integer type;
		private java.lang.Boolean autoApply;
		private java.lang.Double minimumAmount;
		private java.lang.Double couponQuantity;
		private java.lang.Double value;
		private java.lang.Double totalDiscountAmount;

	// many to one
	private com.floreantpos.model.Ticket ticket;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
		public long getVersion () {
					return version;
			}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
	public void setVersion (long version) {
		this.version = version;
	}




	/**
	 * Return the value associated with the column: DISCOUNT_ID
	 */
		public java.lang.String getDiscountId () {
					return discountId;
			}

	/**
	 * Set the value related to the column: DISCOUNT_ID
	 * @param discountId the DISCOUNT_ID value
	 */
	public void setDiscountId (java.lang.String discountId) {
		this.discountId = discountId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */
		public java.lang.String getName () {
					return name;
			}

	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
	public void setName (java.lang.String name) {
		this.name = name;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */
		public java.lang.Integer getType () {
									return type == null ? Integer.valueOf(0) : type;
					}

	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
	public void setType (java.lang.Integer type) {
		this.type = type;
	}



	/**
	 * Return the value associated with the column: AUTO_APPLY
	 */
		public java.lang.Boolean isAutoApply () {
								return autoApply == null ? Boolean.FALSE : autoApply;
					}

	/**
	 * Set the value related to the column: AUTO_APPLY
	 * @param autoApply the AUTO_APPLY value
	 */
	public void setAutoApply (java.lang.Boolean autoApply) {
		this.autoApply = autoApply;
	}



	/**
	 * Return the value associated with the column: MINIMUM_TAMOUNT
	 */
		public java.lang.Double getMinimumAmount () {
									return minimumAmount == null ? Double.valueOf(0) : minimumAmount;
					}

	/**
	 * Set the value related to the column: MINIMUM_TAMOUNT
	 * @param minimumAmount the MINIMUM_TAMOUNT value
	 */
	public void setMinimumAmount (java.lang.Double minimumAmount) {
		this.minimumAmount = minimumAmount;
	}



	/**
	 * Return the value associated with the column: COUPON_QUANITY
	 */
		public java.lang.Double getCouponQuantity () {
									return couponQuantity == null ? Double.valueOf(0) : couponQuantity;
					}

	/**
	 * Set the value related to the column: COUPON_QUANITY
	 * @param couponQuantity the COUPON_QUANITY value
	 */
	public void setCouponQuantity (java.lang.Double couponQuantity) {
		this.couponQuantity = couponQuantity;
	}



	/**
	 * Return the value associated with the column: VALUE
	 */
		public java.lang.Double getValue () {
									return value == null ? Double.valueOf(0) : value;
					}

	/**
	 * Set the value related to the column: VALUE
	 * @param value the VALUE value
	 */
	public void setValue (java.lang.Double value) {
		this.value = value;
	}



	/**
	 * Return the value associated with the column: TOTAL_AMOUNT
	 */
		public java.lang.Double getTotalDiscountAmount () {
									return totalDiscountAmount == null ? Double.valueOf(0) : totalDiscountAmount;
					}

	/**
	 * Set the value related to the column: TOTAL_AMOUNT
	 * @param totalDiscountAmount the TOTAL_AMOUNT value
	 */
	public void setTotalDiscountAmount (java.lang.Double totalDiscountAmount) {
		this.totalDiscountAmount = totalDiscountAmount;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */
		public com.floreantpos.model.Ticket getTicket () {
					return ticket;
			}

	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticket the TICKET_ID value
	 */
	public void setTicket (com.floreantpos.model.Ticket ticket) {
		this.ticket = ticket;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TicketDiscount)) return false;
		else {
			com.floreantpos.model.TicketDiscount ticketDiscount = (com.floreantpos.model.TicketDiscount) obj;
			if (null == this.getId() || null == ticketDiscount.getId()) return this == obj;
			else return (this.getId().equals(ticketDiscount.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}