package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecipeTable;

public class RecipeTableDAO extends BaseRecipeTableDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RecipeTableDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public RecipeTable findBy(String menuItemId) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.createAlias(RecipeTable.PROP_MENU_ITEM, "item");
			criteria.add(Restrictions.eq("item.id", menuItemId));
			return (RecipeTable) criteria.uniqueResult();
		} finally {
			closeSession(session);
		}
	}

	public List<MenuItem> findMenuItems(Recepie recipe) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.distinct(Projections.property(RecipeTable.PROP_MENU_ITEM)));
			criteria.createAlias("recipeList", "r");
			criteria.add(Restrictions.eq("r.id", recipe.getId()));
			return criteria.list();
		} finally {
			closeSession(session);
		}
	}

	public List<RecipeTable> findRecipeTables(Recepie recipe) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.createAlias("recipeList", "r");
			criteria.add(Restrictions.eq("r.id", recipe.getId()));
			return criteria.list();
		} finally {
			closeSession(session);
		}
	}

	public List<RecipeTable> findRecipeTables(String searchString) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			if (StringUtils.isNotEmpty(searchString)) {
				Disjunction disjunction = Restrictions.disjunction();
				criteria.createAlias("recipeList", "r");
				disjunction.add(Restrictions.ilike("r.name", searchString, MatchMode.ANYWHERE));
				criteria.createAlias(RecipeTable.PROP_MENU_ITEM, "item");
				disjunction.add(Restrictions.ilike("item", searchString, MatchMode.ANYWHERE));
				criteria.add(disjunction);
			}
			return criteria.list();
		} finally {
			closeSession(session);
		}
	}

	public void saveRecipeTables(List<MenuItem> menuItems, Object... objects) {
		Session session = null;
		Transaction tx = null;

		try {
			session = createNewSession();
			tx = session.beginTransaction();
			if (objects != null) {
				for (Object object : objects) {
					if (object != null) {
						session.saveOrUpdate(object);
					}
				}
			}
			if (menuItems != null) {
				for (MenuItem menuItem : menuItems) {
					RecipeTable recipeTable = findBy(menuItem.getId());
					if (recipeTable != null)
						session.delete(recipeTable);
				}
			}
			tx.commit();
		} catch (Exception e) {
			try {
				tx.rollback();
			} catch (Exception x) {
			}
			throw e;
		} finally {
			closeSession(session);
		}
	}
}