package com.floreantpos.model.dao;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.TicketPaymentAllocation;

public class TicketPaymentAllocationDAO extends BaseTicketPaymentAllocationDAO {
	
	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session s) throws HibernateException {
		TicketPaymentAllocation paymentAllocation = (TicketPaymentAllocation) obj;
		paymentAllocation.setDeleted(true);
		update(paymentAllocation, s);
	}

	public TicketPaymentAllocation findTicketPaymentAllocationBy(String transactionId) {

		try (Session session = createNewSession()) {

			Criteria criteria = session.createCriteria(TicketPaymentAllocation.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(transactionId)) {
				criteria.add(Restrictions.eq(TicketPaymentAllocation.PROP_TRANSACTION_ID, transactionId));
			}
			criteria.setMaxResults(1);

			return (TicketPaymentAllocation) criteria.uniqueResult();

		}
	}

}