package com.floreantpos.gsonAdapter;

import java.lang.reflect.Type;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Address;
import com.floreantpos.model.Agent;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.Patient;
import com.floreantpos.model.dao.AddressDAO;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class CustomerAdapter implements JsonSerializer<Customer> {

	@Override
	public JsonElement serialize(Customer src, Type typeOfSrc, JsonSerializationContext context) {
		JsonObject jsonObject = new JsonObject();

		jsonObject.addProperty(Customer.PROP_ID, src.getId());
		jsonObject.addProperty(Customer.PROP_FIRST_NAME, src.getFirstName());
		jsonObject.addProperty(Customer.PROP_LAST_NAME, src.getLastName());
		jsonObject.addProperty(Customer.PROP_EMAIL, src.getEmail());
		jsonObject.addProperty(Customer.PROP_MOBILE_NO, src.getMobileNo());
		jsonObject.addProperty(Customer.PROP_ADDRESS, src.getAddress());
		jsonObject.addProperty(Customer.PROP_COUNTRY, src.getCountry());
		jsonObject.addProperty(Customer.PROP_STATE, src.getState());
		jsonObject.addProperty(Customer.PROP_CITY, src.getCity());
		jsonObject.addProperty(Customer.PROP_ZIP_CODE, src.getZipCode());

		if (src instanceof Patient) {
			jsonObject.addProperty("patientGender", src.getGender());
			Date dateOfBirth = src.getDateOfBirth();
			if (dateOfBirth != null) {
				jsonObject.addProperty(Customer.PROP_DATE_OF_BIRTH, dateOfBirth.toString());
			}
			jsonObject.addProperty(Customer.PROP_MOBILE_NO, src.getMobileNo());
			jsonObject.addProperty(Customer.PROP_MEMBER_ID, src.getMemberId());
			jsonObject.addProperty(Customer.PROP_EMAIL, src.getEmail());
			jsonObject.addProperty("patientBloodGroup", src.getBloodGroup());
			jsonObject.addProperty("PatientAddressLine", src.getPatientAddressLine());
			jsonObject.addProperty("ReasonForRegistration", src.getPatientRegistrationReason());
			jsonObject.addProperty("HealthHistory", src.getPatientHealthHistory());

			jsonObject.addProperty("EmergencyContacts", src.getProperty("patient.emergency.contact"));
			jsonObject.addProperty("DisclosureContacts", src.getProperty("patient.disclosure.contact"));

		}
		else if (src instanceof Doctor) {

			jsonObject.addProperty("DoctorDepartment", src.getDepartmentName());
			jsonObject.addProperty("DoctorDesignation", src.getDoctorDesignation());
			jsonObject.addProperty("DoctorOrganization", src.getDoctorOrganization());
			jsonObject.addProperty("DoctorDegreesAndTraining", src.getDoctorDegreesAndTraining());
			jsonObject.addProperty("DoctorAddressLine", src.getDoctorAddressLine());
			jsonObject.addProperty("ScheduleToVisit", src.getDoctorScheduleToVisit());
			jsonObject.addProperty("Agent", src.getAgentName());
			jsonObject.addProperty("DoctorReceiveReferralFee", src.isReceiveReferralFee());
			jsonObject.addProperty("DoctorReferralFee", src.getDoctorRfRateOnReport());
			jsonObject.addProperty("Labdoctor", src.getLabDoctor());
			jsonObject.addProperty("IndorDoctor", src.getIndorDoctor());
		}
		else if (src instanceof Agent) {
			jsonObject.addProperty("AgentType", src.getAgentType());
			jsonObject.addProperty("AgentSalary", src.getAgentSalary());
			jsonObject.addProperty("CommissionOnReportType", src.getRfOnReportType());
			jsonObject.addProperty("CommisionOnReport", src.getRfRateOnReport());
			jsonObject.addProperty("CommisionOnNetSales", src.getRfRateOnNetSales());
			jsonObject.addProperty("CommissionOnNetSalesType", src.getAgentSalary());
			Agent doctorAgent = src.getDoctorAgent();
			if (doctorAgent != null) {
				jsonObject.addProperty("AgentDoctor", doctorAgent.toString());
			}
			else {
				jsonObject.addProperty("AgentDoctor", "");
			}
			String addressId = src.getAddress();
			Address b2bAddress = null;
			if (StringUtils.isNotBlank(addressId)) {
				b2bAddress = AddressDAO.getInstance().get(addressId);
				if (b2bAddress != null) {
					jsonObject.addProperty("AgentCompanyName", b2bAddress.getName());
					jsonObject.addProperty("CompanyAddressLineOne", b2bAddress.getAddressLine1());
					jsonObject.addProperty("CompanyAddressLineTwo", b2bAddress.getAddressLine2());
					jsonObject.addProperty("CompanyHotline", b2bAddress.getPhone());
				}
			}
			
		}
		return jsonObject;
	}

}
