package com.floreantpos.report.model;

import com.floreantpos.model.COAAccountType;
import com.floreantpos.model.COAAccountTypeGroup;
import com.floreantpos.model.ChartOfAccounts;
import com.floreantpos.model.LedgerEntry;
import com.floreantpos.model.dao.COAAccountTypeDAO;
import com.floreantpos.model.dao.COAAccountTypeGroupDAO;
import com.floreantpos.model.dao.ChartOfAccountsDAO;
import com.floreantpos.swing.ListTableModel;

public class LedgerEntryReportModel extends ListTableModel {
	public LedgerEntryReportModel() {
		super(new String[] { "coaId", "coaName", "date", "description", "debit", "credit", "direction", "refNo" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		LedgerEntry reportData = (LedgerEntry) rows.get(rowIndex);
		ChartOfAccounts chartOfAccounts = ChartOfAccountsDAO.getInstance().get(reportData.getAccountId());

		switch (columnIndex) {
			case 0:
				return reportData.getAccountId();
			case 1:
				if (chartOfAccounts == null) {
					return "";
				}
				return chartOfAccounts.getName();
			case 2:
				return reportData.getDateDisplay();
			case 3:
				return reportData.getDescription();
			case 4:
				return reportData.getDebitDirectionDisplay();
			case 5:
				return reportData.getCreditDirectionDisplay();
			case 6:
				chartOfAccounts = ChartOfAccountsDAO.getInstance().get(reportData.getAccountId());
				if (chartOfAccounts != null) {
					COAAccountType coaAccountType = COAAccountTypeDAO.getInstance().get(chartOfAccounts.getCoaAccountTypeId());
					COAAccountTypeGroup group = COAAccountTypeGroupDAO.getInstance().get(coaAccountType.getCoaAccountTypeGroupId());
					return group.getAccountDirection();
				}
				return 0;
			case 7:
				return reportData.getGroupId();

		}
		return null;
	}

}