package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCashBreakdown;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "cashDrawer" })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class CashBreakdown extends BaseCashBreakdown implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public CashBreakdown() {
	}

	@XmlTransient
	public Currency getCurrency() {
		CashDrawer cashDrawer = getCashDrawer();
		return DataProvider.get().getCurrency(getCurrencyId(), cashDrawer == null ? null : cashDrawer.getOutletId());
	}

	public void setCurrency(Currency currency) {
		if (currency == null) {
			setCurrencyId(null);
		}
		else {
			setCurrencyId(currency.getId());
		}
	}

	public String getCurrencyName() {
		Currency currency = getCurrency();
		if (currency != null) {
			return currency.getName();
		}
		return null;
	}

	public void setCurrencyName(String currencyName) {
	}

	@XmlTransient
	public CashDrawer getCashDrawer() {
		String cashDrawerId = getCashDrawerId();
		if (StringUtils.isNotEmpty(cashDrawerId)) {
			return CashDrawerDAO.getInstance().get(cashDrawerId);
		}
		return null;
	}

	public void setCashDrawer(CashDrawer cashDrawer) {
		if (cashDrawer != null) {
			setCashDrawerId(cashDrawer.getId());
		}
		else {
			setCashDrawerId(null);
		}
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}
	//	public Double getBalance() {
	//		CashDrawer cashDrawer = getCashDrawer();
	//		return (cashDrawer == null || cashDrawer.getReportTime() == null) ? super.getBalance() : super.getTotalAmount();
	//	}
}