package com.floreantpos.model;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.base.BaseCouple;
import com.floreantpos.model.consultation.AdditionalInfo;
import com.floreantpos.model.consultation.AllergyHistory;
import com.floreantpos.model.consultation.FemaleInitialWorkup;
import com.floreantpos.model.consultation.FemaleMenstrualHistory;
import com.floreantpos.model.consultation.FemalePregnancyHistory;
import com.floreantpos.model.consultation.GenericHistory;
import com.floreantpos.model.consultation.InsuranceAndConsent;
import com.floreantpos.model.consultation.LifestyleFactors;
import com.floreantpos.model.consultation.MaleFertilityHistory;
import com.floreantpos.model.consultation.MaleInitialWorkup;
import com.floreantpos.model.consultation.MaleSemenAnalysis;
import com.floreantpos.model.consultation.MedicationHistory;
import com.floreantpos.model.consultation.PreviousFertilityTreatment;
import com.floreantpos.model.consultation.RelationshipHistory;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class Couple extends BaseCouple implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	@JsonIgnore
	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private Patient femalePartner;
	private Patient malePartner;
	private Doctor assignedDoctor;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Couple () {
    }

	/**
	 * Constructor for primary key
	 */
	public Couple (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@JsonIgnore
	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			String jsonProperties = super.getProperties();
			if (StringUtils.isEmpty(jsonProperties)) {
				propertiesContainer = new JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
			}
		}
		return propertiesContainer;
	}

	@Override
	public void setProperties(String jsonProperties) {
		super.setProperties(jsonProperties);
		this.propertiesContainer = null;
		this.femalePartner = null;
		this.malePartner = null;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public Patient getFemalePartner() {
		if (this.femalePartner == null) {
			String femalePartnerId = getFemalePartnerId();
			if (StringUtils.isNotBlank(femalePartnerId)) {
				this.femalePartner = (Patient) DataProvider.get().getObjectOf(Patient.class, femalePartnerId);
			}
		}
		return this.femalePartner;
	}

	public void setFemalePartner(Patient femalePartner) {
		this.femalePartner = femalePartner;
		setFemalePartnerId(femalePartner != null ? femalePartner.getId() : null);
	}

	public Patient getMalePartner() {
		if (this.malePartner == null) {
			String malePartnerId = getMalePartnerId();
			if (StringUtils.isNotBlank(malePartnerId)) {
				this.malePartner = (Patient) DataProvider.get().getObjectOf(Patient.class, malePartnerId);
			}
		}
		return this.malePartner;
	}

	public void setMalePartner(Patient malePartner) {
		this.malePartner = malePartner;
		setMalePartnerId(malePartner != null ? malePartner.getId() : null);
	}

	public Doctor getAssignedDoctor() {
		if (this.assignedDoctor == null) {
			String assignedDoctorId = getAssignedDoctorId();
			if (StringUtils.isNotBlank(assignedDoctorId)) {
				this.assignedDoctor = (Doctor) DataProvider.get().getObjectOf(Doctor.class, assignedDoctorId);
			}
		}
		return this.assignedDoctor;
	}

	public RelationshipHistory getRelationshipHistory() {
		String json = getRelationshipHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, RelationshipHistory.class);
	}

	public void setRelationshipHistory(RelationshipHistory history) {
		setRelationshipHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public PreviousFertilityTreatment getPreviousFertilityTreatment() {
		String json = getPreviousTreatmentJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, PreviousFertilityTreatment.class);
	}

	public void setPreviousFertilityTreatment(PreviousFertilityTreatment treatment) {
		setPreviousTreatmentJson(GsonUtil.createGson().toJson(treatment));
	}

	// --- Female Partner Specific Information ---

	public FemaleMenstrualHistory getFemaleMenstrualHistory() {
		String json = getFemaleMenstrualHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, FemaleMenstrualHistory.class);
	}

	public void setFemaleMenstrualHistory(FemaleMenstrualHistory history) {
		setFemaleMenstrualHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public FemalePregnancyHistory getFemalePregnancyHistory() {
		String json = getFemalePregnancyHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, FemalePregnancyHistory.class);
	}

	public void setFemalePregnancyHistory(FemalePregnancyHistory history) {
		setFemalePregnancyHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public GenericHistory getFemaleGynHistory() {
		String json = getFemaleGynHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setFemaleGynHistory(GenericHistory history) {
		setFemaleGynHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public GenericHistory getFemaleMedicalHistory() {
		String json = getFemaleMedicalHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setFemaleMedicalHistory(GenericHistory history) {
		setFemaleMedicalHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public GenericHistory getFemaleSurgicalHistory() {
		String json = getFemaleSurgicalHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setFemaleSurgicalHistory(GenericHistory history) {
		setFemaleSurgicalHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public MedicationHistory getFemaleMedicationHistory() {
		String json = getFemaleMedicationsJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, MedicationHistory.class);
	}

	public void setFemaleMedicationHistory(MedicationHistory history) {
		setFemaleMedicationsJson(GsonUtil.createGson().toJson(history));
	}

	public AllergyHistory getFemaleAllergyHistory() {
		String json = getFemaleAllergiesJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, AllergyHistory.class);
	}

	public void setFemaleAllergyHistory(AllergyHistory history) {
		setFemaleAllergiesJson(GsonUtil.createGson().toJson(history));
	}

	public LifestyleFactors getFemaleLifestyleFactors() {
		String json = getFemaleLifestyleJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, LifestyleFactors.class);
	}

	public void setFemaleLifestyleFactors(LifestyleFactors factors) {
		setFemaleLifestyleJson(GsonUtil.createGson().toJson(factors));
	}

	public GenericHistory getFemaleFamilyHistory() {
		String json = getFemaleFamilyHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setFemaleFamilyHistory(GenericHistory history) {
		setFemaleFamilyHistoryJson(GsonUtil.createGson().toJson(history));
	}

	// --- Male Partner Specific Information ---

	public MaleFertilityHistory getMaleFertilityHistory() {
		String json = getMaleFertilityHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, MaleFertilityHistory.class);
	}

	public void setMaleFertilityHistory(MaleFertilityHistory history) {
		setMaleFertilityHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public MaleSemenAnalysis getMaleSemenAnalysis() {
		String json = getMaleSemenAnalysisJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, MaleSemenAnalysis.class);
	}

	public void setMaleSemenAnalysis(MaleSemenAnalysis analysis) {
		setMaleSemenAnalysisJson(GsonUtil.createGson().toJson(analysis));
	}

	public GenericHistory getMaleMedicalHistory() {
		String json = getMaleMedicalHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setMaleMedicalHistory(GenericHistory history) {
		setMaleMedicalHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public GenericHistory getMaleSurgicalHistory() {
		String json = getMaleSurgicalHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setMaleSurgicalHistory(GenericHistory history) {
		setMaleSurgicalHistoryJson(GsonUtil.createGson().toJson(history));
	}

	public MedicationHistory getMaleMedicationHistory() {
		String json = getMaleMedicationsJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, MedicationHistory.class);
	}

	public void setMaleMedicationHistory(MedicationHistory history) {
		setMaleMedicationsJson(GsonUtil.createGson().toJson(history));
	}

	public AllergyHistory getMaleAllergyHistory() {
		String json = getMaleAllergiesJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, AllergyHistory.class);
	}

	public void setMaleAllergyHistory(AllergyHistory history) {
		setMaleAllergiesJson(GsonUtil.createGson().toJson(history));
	}

	public LifestyleFactors getMaleLifestyleFactors() {
		String json = getMaleLifestyleJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, LifestyleFactors.class);
	}

	public void setMaleLifestyleFactors(LifestyleFactors factors) {
		setMaleLifestyleJson(GsonUtil.createGson().toJson(factors));
	}

	public GenericHistory getMaleFamilyHistory() {
		String json = getMaleFamilyHistoryJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, GenericHistory.class);
	}

	public void setMaleFamilyHistory(GenericHistory history) {
		setMaleFamilyHistoryJson(GsonUtil.createGson().toJson(history));
	}

	// --- Initial Workup Information ---

	public MaleInitialWorkup getMaleInitialWorkup() {
		String json = getMaleInitialWorkupJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, MaleInitialWorkup.class);
	}

	public void setMaleInitialWorkup(MaleInitialWorkup workup) {
		setMaleInitialWorkupJson(GsonUtil.createGson().toJson(workup));
	}

	public FemaleInitialWorkup getFemaleInitialWorkup() {
		String json = getFemaleInitialWorkupJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, FemaleInitialWorkup.class);
	}

	public void setFemaleInitialWorkup(FemaleInitialWorkup workup) {
		setFemaleInitialWorkupJson(GsonUtil.createGson().toJson(workup));
	}

	// --- Administrative and Final Information ---

	public InsuranceAndConsent getInsuranceAndConsent() {
		String json = getAdminAndConsentJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, InsuranceAndConsent.class);
	}

	public void setInsuranceAndConsent(InsuranceAndConsent info) {
		setAdminAndConsentJson(GsonUtil.createGson().toJson(info));
	}

	public AdditionalInfo getAdditionalInfo() {
		String json = getAdditionalInfoJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return GsonUtil.createGson().fromJson(json, AdditionalInfo.class);
	}

	public void setAdditionalInfo(AdditionalInfo info) {
		setAdditionalInfoJson(GsonUtil.createGson().toJson(info));
	}

}