package com.floreantpos.model;

import com.floreantpos.model.base.BaseEmbryo;

public class Embryo extends BaseEmbryo {
	private static final long serialVersionUID = 1L;
	private String cyclePlanId;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Embryo () {
    }

	/**
	 * Constructor for primary key
	 */
	public Embryo (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public Embryo (
		java.lang.String id,
		com.floreantpos.model.CyclePlan cyclePlan) {

		super (
			id,
			cyclePlan);
	}

	/*[CONSTRUCTOR MARKER END]*/

	/**
	 * Override getCyclePlan to prevent circular reference during JSON serialization
	 */
	@Override
	public CyclePlan getCyclePlan() {
		CyclePlan cyclePlan = super.getCyclePlan();
		if (cyclePlan != null) {
			cyclePlanId = cyclePlan.getId();
		}
		return cyclePlan;
	}

	public String getCyclePlanId() {
		return cyclePlanId;
	}

	public void setCyclePlanId(String cyclePlanId) {
		this.cyclePlanId = cyclePlanId;
	}

}