package com.floreantpos.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseProtocolPhase;
import com.floreantpos.model.consultation.CycleMedication;
import com.floreantpos.model.consultation.CycleMonitoringTask;
import com.floreantpos.model.consultation.ProtocolPhaseTemplete;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;

public class ProtocolPhase extends BaseProtocolPhase implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private String cyclePlanId;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ProtocolPhase () {
    }

	/**
	 * Constructor for primary key
	 */
	public ProtocolPhase (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public ProtocolPhase (
		java.lang.String id,
		com.floreantpos.model.CyclePlan cyclePlan) {

		super (
			id,
			cyclePlan);
	}

	/*[CONSTRUCTOR MARKER END]*/

	/**
	 * Factory method to create a ProtocolPhase from a ProtocolPhaseTemplete (deep copy)
	 */
	public static ProtocolPhase fromTemplate(ProtocolPhaseTemplete template) {
		if (template == null) {
			return null;
		}

		ProtocolPhase phase = new ProtocolPhase();
		phase.setPhaseName(template.getPhaseName());
		phase.setDescription(template.getDescription());
		phase.setEstimatedStartDay(template.getEstimatedStartDay());
		phase.setEstimatedDurationDays(template.getEstimatedDurationDays());
		phase.setSortOrder(template.getSortOrder());

		// Deep copy medications
		if (template.getMedications() != null) {
			List<CycleMedication> medications = new ArrayList<>();
			for (com.floreantpos.model.consultation.ProtocolMedication medTemplate : template.getMedications()) {
				medications.add(CycleMedication.fromTemplate(medTemplate));
			}
			phase.setMedications(medications);
		}

		// Deep copy monitoring tasks
		if (template.getMonitoringTasks() != null) {
			List<CycleMonitoringTask> tasks = new ArrayList<>();
			for (com.floreantpos.model.consultation.ProtocolMonitoringTask taskTemplate : template.getMonitoringTasks()) {
				tasks.add(CycleMonitoringTask.fromTemplate(taskTemplate));
			}
			phase.setMonitoringTasks(tasks);
		}

		return phase;
	}

	/**
	 * Factory method to create a ProtocolPhase from a POJO ProtocolPhase (for migration)
	 */
	public static ProtocolPhase fromPOJO(com.floreantpos.model.consultation.ProtocolPhase pojo) {
		if (pojo == null) {
			return null;
		}

		ProtocolPhase phase = new ProtocolPhase();
		phase.setPhaseName(pojo.getPhaseName());
		phase.setDescription(pojo.getDescription());
		phase.setEstimatedStartDay(pojo.getEstimatedStartDay());
		phase.setEstimatedDurationDays(pojo.getEstimatedDurationDays());
		phase.setSortOrder(pojo.getSortOrder());
		phase.setActualStartDate(pojo.getActualStartDate());
		phase.setActualEndDate(pojo.getActualEndDate());
		phase.setStatus(pojo.getStatus());
		phase.setMedications(pojo.getMedications());
		phase.setMonitoringTasks(pojo.getMonitoringTasks());

		return phase;
	}

	/**
	 * Override getCyclePlan to prevent circular reference during JSON serialization
	 */
	@Override
	public CyclePlan getCyclePlan() {
		CyclePlan cyclePlan = super.getCyclePlan();
		if (cyclePlan != null) {
			setCyclePlanId(cyclePlan.getId());
		}
		return cyclePlan;
	}

	public String getCyclePlanId() {
		return cyclePlanId;
	}

	public void setCyclePlanId(String cyclePlanId) {
		this.cyclePlanId = cyclePlanId;
	}

	/**
	 * Get the list of medications
	 */
	public List<CycleMedication> getMedications() {
		Gson gson = GsonUtil.createGson();
		String json = getMedicationsJson();
		if (StringUtils.isBlank(json)) {
			return new ArrayList<>();
		}
		return gson.fromJson(json, new TypeToken<List<CycleMedication>>() {}.getType());
	}

	/**
	 * Set the list of medications
	 */
	public void setMedications(List<CycleMedication> medications) {
		Gson gson = GsonUtil.createGson();
		setMedicationsJson(gson.toJson(medications));
	}

	/**
	 * Get the list of monitoring tasks
	 */
	public List<CycleMonitoringTask> getMonitoringTasks() {
		Gson gson = GsonUtil.createGson();
		String json = getMonitoringTasksJson();
		if (StringUtils.isBlank(json)) {
			return new ArrayList<>();
		}
		return gson.fromJson(json, new TypeToken<List<CycleMonitoringTask>>() {}.getType());
	}

	/**
	 * Set the list of monitoring tasks
	 */
	public void setMonitoringTasks(List<CycleMonitoringTask> tasks) {
		Gson gson = GsonUtil.createGson();
		setMonitoringTasksJson(gson.toJson(tasks));
	}

	/**
	 * Get the list of cycle stage logs as a sorted list
	 */
	public List<CycleStageLog> getCycleStageLogsList() {
		java.util.Set<CycleStageLog> stageLogs = getCycleStageLogs();
		if (stageLogs == null || stageLogs.isEmpty()) {
			return new ArrayList<>();
		}
		List<CycleStageLog> list = new ArrayList<>(stageLogs);
		list.sort((l1, l2) -> {
			Date d1 = l1.getCreatedDate();
			Date d2 = l2.getCreatedDate();
			if (d1 == null && d2 == null) return 0;
			if (d1 == null) return 1;
			if (d2 == null) return -1;
			return d1.compareTo(d2);
		});
		return list;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public void setProperties(String jsonProperties) {
		super.setProperties(jsonProperties);
		this.propertiesContainer = null;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}
}
