package com.floreantpos.model;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.base.BaseProtocolTemplate;
import com.floreantpos.model.consultation.ProtocolPhaseTemplete;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;

public class ProtocolTemplate extends BaseProtocolTemplate implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	@JsonIgnore
	private transient com.google.gson.JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ProtocolTemplate () {
    }

	/**
	 * Constructor for primary key
	 */
	public ProtocolTemplate (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@JsonIgnore
	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public void setProperties(String jsonProperties) {
		super.setProperties(jsonProperties);
		this.propertiesContainer = null;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public List<ProtocolPhaseTemplete> getProtocolPhases() {
		Gson gson = GsonUtil.createGson();
		String json = getProtocolPhaseTemplateJson();
		if (StringUtils.isBlank(json)) {
			return null;
		}
		return gson.fromJson(json, new TypeToken<List<ProtocolPhaseTemplete>>() {
		}.getType());
	}

	public void setProtocolPhases(List<ProtocolPhaseTemplete> phases) {
		Gson gson = GsonUtil.createGson();
		setProtocolPhaseTemplateJson(gson.toJson(phases));
	}

}