package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseTerminalPrinters;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class TerminalPrinters extends BaseTerminalPrinters implements PropertyContainer {
	private static final long serialVersionUID = 1L;
	public static final String PRINTER_TYPE = "printerType";
	public static final String IP_ADDRESS = "ipAddress";
	public static final String IP_PORT = "ipPort";
	public static final String SERIAL_PORT = "serialPort";
	public static final String TEXT_LENGTH = "textLength";

	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TerminalPrinters() {
	}

	/**
	 * Constructor for primary key
	 */
	public TerminalPrinters(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}
}