package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the COUPLE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="COUPLE"
 */

public abstract class BaseCouple  implements Comparable, Serializable {

	public static String REF = "Couple"; //$NON-NLS-1$
	public static String PROP_MALE_SURGICAL_HISTORY_JSON = "maleSurgicalHistoryJson"; //$NON-NLS-1$
	public static String PROP_CONSULTATION_STATUS = "consultationStatus"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_MALE_PARTNER_ID = "malePartnerId"; //$NON-NLS-1$
	public static String PROP_FEMALE_PARTNER_ID = "femalePartnerId"; //$NON-NLS-1$
	public static String PROP_MALE_MEDICAL_HISTORY_JSON = "maleMedicalHistoryJson"; //$NON-NLS-1$
	public static String PROP_MALE_ALLERGIES_JSON = "maleAllergiesJson"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_MALE_INITIAL_WORKUP_JSON = "maleInitialWorkupJson"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_FEMALE_PREGNANCY_HISTORY_JSON = "femalePregnancyHistoryJson"; //$NON-NLS-1$
	public static String PROP_FEMALE_ALLERGIES_JSON = "femaleAllergiesJson"; //$NON-NLS-1$
	public static String PROP_MALE_FAMILY_HISTORY_JSON = "maleFamilyHistoryJson"; //$NON-NLS-1$
	public static String PROP_ADDITIONAL_INFO_JSON = "additionalInfoJson"; //$NON-NLS-1$
	public static String PROP_ADMIN_AND_CONSENT_JSON = "adminAndConsentJson"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_CONSULTATION_DATE = "consultationDate"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_FEMALE_FAMILY_HISTORY_JSON = "femaleFamilyHistoryJson"; //$NON-NLS-1$
	public static String PROP_FEMALE_SURGICAL_HISTORY_JSON = "femaleSurgicalHistoryJson"; //$NON-NLS-1$
	public static String PROP_FEMALE_MEDICATIONS_JSON = "femaleMedicationsJson"; //$NON-NLS-1$
	public static String PROP_FEMALE_MEDICAL_HISTORY_JSON = "femaleMedicalHistoryJson"; //$NON-NLS-1$
	public static String PROP_PREVIOUS_TREATMENT_JSON = "previousTreatmentJson"; //$NON-NLS-1$
	public static String PROP_MALE_LIFESTYLE_JSON = "maleLifestyleJson"; //$NON-NLS-1$
	public static String PROP_FEMALE_LIFESTYLE_JSON = "femaleLifestyleJson"; //$NON-NLS-1$
	public static String PROP_MALE_SEMEN_ANALYSIS_JSON = "maleSemenAnalysisJson"; //$NON-NLS-1$
	public static String PROP_MALE_MEDICATIONS_JSON = "maleMedicationsJson"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_FEMALE_GYN_HISTORY_JSON = "femaleGynHistoryJson"; //$NON-NLS-1$
	public static String PROP_FEMALE_MENSTRUAL_HISTORY_JSON = "femaleMenstrualHistoryJson"; //$NON-NLS-1$
	public static String PROP_RELATIONSHIP_HISTORY_JSON = "relationshipHistoryJson"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_FEMALE_INITIAL_WORKUP_JSON = "femaleInitialWorkupJson"; //$NON-NLS-1$
	public static String PROP_MALE_FERTILITY_HISTORY_JSON = "maleFertilityHistoryJson"; //$NON-NLS-1$
	public static String PROP_ASSIGNED_DOCTOR_ID = "assignedDoctorId"; //$NON-NLS-1$


	// constructors
	public BaseCouple () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCouple (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String malePartnerId;
				private java.lang.String femalePartnerId;
				private java.lang.String assignedDoctorId;
				private java.lang.String consultationStatus;
				private java.util.Date consultationDate;
				private java.lang.String maleInitialWorkupJson;
				private java.lang.String femaleInitialWorkupJson;
				private java.lang.String relationshipHistoryJson;
				private java.lang.String previousTreatmentJson;
				private java.lang.String femaleMenstrualHistoryJson;
				private java.lang.String femalePregnancyHistoryJson;
				private java.lang.String femaleGynHistoryJson;
				private java.lang.String femaleMedicalHistoryJson;
				private java.lang.String femaleSurgicalHistoryJson;
				private java.lang.String femaleMedicationsJson;
				private java.lang.String femaleAllergiesJson;
				private java.lang.String femaleLifestyleJson;
				private java.lang.String femaleFamilyHistoryJson;
				private java.lang.String maleFertilityHistoryJson;
				private java.lang.String maleSemenAnalysisJson;
				private java.lang.String maleMedicalHistoryJson;
				private java.lang.String maleSurgicalHistoryJson;
				private java.lang.String maleMedicationsJson;
				private java.lang.String maleAllergiesJson;
				private java.lang.String maleLifestyleJson;
				private java.lang.String maleFamilyHistoryJson;
				private java.lang.String adminAndConsentJson;
				private java.lang.String additionalInfoJson;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: MALE_PARTNER_ID
	 */

	public java.lang.String getMalePartnerId () {
			return malePartnerId;
	}



	/**
	 * Set the value related to the column: MALE_PARTNER_ID
	 * @param malePartnerId the MALE_PARTNER_ID value
	 */
			public void setMalePartnerId (java.lang.String malePartnerId) {
			this.malePartnerId = malePartnerId;
	}



	/**
	 * Return the value associated with the column: FEMALE_PARTNER_ID
	 */

	public java.lang.String getFemalePartnerId () {
			return femalePartnerId;
	}



	/**
	 * Set the value related to the column: FEMALE_PARTNER_ID
	 * @param femalePartnerId the FEMALE_PARTNER_ID value
	 */
			public void setFemalePartnerId (java.lang.String femalePartnerId) {
			this.femalePartnerId = femalePartnerId;
	}



	/**
	 * Return the value associated with the column: ASSIGNED_DOCTOR_ID
	 */

	public java.lang.String getAssignedDoctorId () {
			return assignedDoctorId;
	}



	/**
	 * Set the value related to the column: ASSIGNED_DOCTOR_ID
	 * @param assignedDoctorId the ASSIGNED_DOCTOR_ID value
	 */
			public void setAssignedDoctorId (java.lang.String assignedDoctorId) {
			this.assignedDoctorId = assignedDoctorId;
	}



	/**
	 * Return the value associated with the column: CONSULTATION_STATUS
	 */

	public java.lang.String getConsultationStatus () {
			return consultationStatus;
	}



	/**
	 * Set the value related to the column: CONSULTATION_STATUS
	 * @param consultationStatus the CONSULTATION_STATUS value
	 */
			public void setConsultationStatus (java.lang.String consultationStatus) {
			this.consultationStatus = consultationStatus;
	}



	/**
	 * Return the value associated with the column: CONSULTATION_DATE
	 */

	public java.util.Date getConsultationDate () {
			return consultationDate;
	}



	/**
	 * Set the value related to the column: CONSULTATION_DATE
	 * @param consultationDate the CONSULTATION_DATE value
	 */
			public void setConsultationDate (java.util.Date consultationDate) {
			this.consultationDate = consultationDate;
	}



	/**
	 * Return the value associated with the column: MALE_INITIAL_WORKUP_JSON
	 */

	public java.lang.String getMaleInitialWorkupJson () {
			return maleInitialWorkupJson;
	}



	/**
	 * Set the value related to the column: MALE_INITIAL_WORKUP_JSON
	 * @param maleInitialWorkupJson the MALE_INITIAL_WORKUP_JSON value
	 */
			public void setMaleInitialWorkupJson (java.lang.String maleInitialWorkupJson) {
			this.maleInitialWorkupJson = maleInitialWorkupJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_INITIAL_WORKUP_JSON
	 */

	public java.lang.String getFemaleInitialWorkupJson () {
			return femaleInitialWorkupJson;
	}



	/**
	 * Set the value related to the column: FEMALE_INITIAL_WORKUP_JSON
	 * @param femaleInitialWorkupJson the FEMALE_INITIAL_WORKUP_JSON value
	 */
			public void setFemaleInitialWorkupJson (java.lang.String femaleInitialWorkupJson) {
			this.femaleInitialWorkupJson = femaleInitialWorkupJson;
	}



	/**
	 * Return the value associated with the column: RELATIONSHIP_HISTORY_JSON
	 */

	public java.lang.String getRelationshipHistoryJson () {
			return relationshipHistoryJson;
	}



	/**
	 * Set the value related to the column: RELATIONSHIP_HISTORY_JSON
	 * @param relationshipHistoryJson the RELATIONSHIP_HISTORY_JSON value
	 */
			public void setRelationshipHistoryJson (java.lang.String relationshipHistoryJson) {
			this.relationshipHistoryJson = relationshipHistoryJson;
	}



	/**
	 * Return the value associated with the column: PREVIOUS_TREATMENT_JSON
	 */

	public java.lang.String getPreviousTreatmentJson () {
			return previousTreatmentJson;
	}



	/**
	 * Set the value related to the column: PREVIOUS_TREATMENT_JSON
	 * @param previousTreatmentJson the PREVIOUS_TREATMENT_JSON value
	 */
			public void setPreviousTreatmentJson (java.lang.String previousTreatmentJson) {
			this.previousTreatmentJson = previousTreatmentJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_MENSTRUAL_HISTORY_JSON
	 */

	public java.lang.String getFemaleMenstrualHistoryJson () {
			return femaleMenstrualHistoryJson;
	}



	/**
	 * Set the value related to the column: FEMALE_MENSTRUAL_HISTORY_JSON
	 * @param femaleMenstrualHistoryJson the FEMALE_MENSTRUAL_HISTORY_JSON value
	 */
			public void setFemaleMenstrualHistoryJson (java.lang.String femaleMenstrualHistoryJson) {
			this.femaleMenstrualHistoryJson = femaleMenstrualHistoryJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_PREGNANCY_HISTORY_JSON
	 */

	public java.lang.String getFemalePregnancyHistoryJson () {
			return femalePregnancyHistoryJson;
	}



	/**
	 * Set the value related to the column: FEMALE_PREGNANCY_HISTORY_JSON
	 * @param femalePregnancyHistoryJson the FEMALE_PREGNANCY_HISTORY_JSON value
	 */
			public void setFemalePregnancyHistoryJson (java.lang.String femalePregnancyHistoryJson) {
			this.femalePregnancyHistoryJson = femalePregnancyHistoryJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_GYN_HISTORY_JSON
	 */

	public java.lang.String getFemaleGynHistoryJson () {
			return femaleGynHistoryJson;
	}



	/**
	 * Set the value related to the column: FEMALE_GYN_HISTORY_JSON
	 * @param femaleGynHistoryJson the FEMALE_GYN_HISTORY_JSON value
	 */
			public void setFemaleGynHistoryJson (java.lang.String femaleGynHistoryJson) {
			this.femaleGynHistoryJson = femaleGynHistoryJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_MEDICAL_HISTORY_JSON
	 */

	public java.lang.String getFemaleMedicalHistoryJson () {
			return femaleMedicalHistoryJson;
	}



	/**
	 * Set the value related to the column: FEMALE_MEDICAL_HISTORY_JSON
	 * @param femaleMedicalHistoryJson the FEMALE_MEDICAL_HISTORY_JSON value
	 */
			public void setFemaleMedicalHistoryJson (java.lang.String femaleMedicalHistoryJson) {
			this.femaleMedicalHistoryJson = femaleMedicalHistoryJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_SURGICAL_HISTORY_JSON
	 */

	public java.lang.String getFemaleSurgicalHistoryJson () {
			return femaleSurgicalHistoryJson;
	}



	/**
	 * Set the value related to the column: FEMALE_SURGICAL_HISTORY_JSON
	 * @param femaleSurgicalHistoryJson the FEMALE_SURGICAL_HISTORY_JSON value
	 */
			public void setFemaleSurgicalHistoryJson (java.lang.String femaleSurgicalHistoryJson) {
			this.femaleSurgicalHistoryJson = femaleSurgicalHistoryJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_MEDICATIONS_JSON
	 */

	public java.lang.String getFemaleMedicationsJson () {
			return femaleMedicationsJson;
	}



	/**
	 * Set the value related to the column: FEMALE_MEDICATIONS_JSON
	 * @param femaleMedicationsJson the FEMALE_MEDICATIONS_JSON value
	 */
			public void setFemaleMedicationsJson (java.lang.String femaleMedicationsJson) {
			this.femaleMedicationsJson = femaleMedicationsJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_ALLERGIES_JSON
	 */

	public java.lang.String getFemaleAllergiesJson () {
			return femaleAllergiesJson;
	}



	/**
	 * Set the value related to the column: FEMALE_ALLERGIES_JSON
	 * @param femaleAllergiesJson the FEMALE_ALLERGIES_JSON value
	 */
			public void setFemaleAllergiesJson (java.lang.String femaleAllergiesJson) {
			this.femaleAllergiesJson = femaleAllergiesJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_LIFESTYLE_JSON
	 */

	public java.lang.String getFemaleLifestyleJson () {
			return femaleLifestyleJson;
	}



	/**
	 * Set the value related to the column: FEMALE_LIFESTYLE_JSON
	 * @param femaleLifestyleJson the FEMALE_LIFESTYLE_JSON value
	 */
			public void setFemaleLifestyleJson (java.lang.String femaleLifestyleJson) {
			this.femaleLifestyleJson = femaleLifestyleJson;
	}



	/**
	 * Return the value associated with the column: FEMALE_FAMILY_HISTORY_JSON
	 */

	public java.lang.String getFemaleFamilyHistoryJson () {
			return femaleFamilyHistoryJson;
	}



	/**
	 * Set the value related to the column: FEMALE_FAMILY_HISTORY_JSON
	 * @param femaleFamilyHistoryJson the FEMALE_FAMILY_HISTORY_JSON value
	 */
			public void setFemaleFamilyHistoryJson (java.lang.String femaleFamilyHistoryJson) {
			this.femaleFamilyHistoryJson = femaleFamilyHistoryJson;
	}



	/**
	 * Return the value associated with the column: MALE_FERTILITY_HISTORY_JSON
	 */

	public java.lang.String getMaleFertilityHistoryJson () {
			return maleFertilityHistoryJson;
	}



	/**
	 * Set the value related to the column: MALE_FERTILITY_HISTORY_JSON
	 * @param maleFertilityHistoryJson the MALE_FERTILITY_HISTORY_JSON value
	 */
			public void setMaleFertilityHistoryJson (java.lang.String maleFertilityHistoryJson) {
			this.maleFertilityHistoryJson = maleFertilityHistoryJson;
	}



	/**
	 * Return the value associated with the column: MALE_SEMEN_ANALYSIS_JSON
	 */

	public java.lang.String getMaleSemenAnalysisJson () {
			return maleSemenAnalysisJson;
	}



	/**
	 * Set the value related to the column: MALE_SEMEN_ANALYSIS_JSON
	 * @param maleSemenAnalysisJson the MALE_SEMEN_ANALYSIS_JSON value
	 */
			public void setMaleSemenAnalysisJson (java.lang.String maleSemenAnalysisJson) {
			this.maleSemenAnalysisJson = maleSemenAnalysisJson;
	}



	/**
	 * Return the value associated with the column: MALE_MEDICAL_HISTORY_JSON
	 */

	public java.lang.String getMaleMedicalHistoryJson () {
			return maleMedicalHistoryJson;
	}



	/**
	 * Set the value related to the column: MALE_MEDICAL_HISTORY_JSON
	 * @param maleMedicalHistoryJson the MALE_MEDICAL_HISTORY_JSON value
	 */
			public void setMaleMedicalHistoryJson (java.lang.String maleMedicalHistoryJson) {
			this.maleMedicalHistoryJson = maleMedicalHistoryJson;
	}



	/**
	 * Return the value associated with the column: MALE_SURGICAL_HISTORY_JSON
	 */

	public java.lang.String getMaleSurgicalHistoryJson () {
			return maleSurgicalHistoryJson;
	}



	/**
	 * Set the value related to the column: MALE_SURGICAL_HISTORY_JSON
	 * @param maleSurgicalHistoryJson the MALE_SURGICAL_HISTORY_JSON value
	 */
			public void setMaleSurgicalHistoryJson (java.lang.String maleSurgicalHistoryJson) {
			this.maleSurgicalHistoryJson = maleSurgicalHistoryJson;
	}



	/**
	 * Return the value associated with the column: MALE_MEDICATIONS_JSON
	 */

	public java.lang.String getMaleMedicationsJson () {
			return maleMedicationsJson;
	}



	/**
	 * Set the value related to the column: MALE_MEDICATIONS_JSON
	 * @param maleMedicationsJson the MALE_MEDICATIONS_JSON value
	 */
			public void setMaleMedicationsJson (java.lang.String maleMedicationsJson) {
			this.maleMedicationsJson = maleMedicationsJson;
	}



	/**
	 * Return the value associated with the column: MALE_ALLERGIES_JSON
	 */

	public java.lang.String getMaleAllergiesJson () {
			return maleAllergiesJson;
	}



	/**
	 * Set the value related to the column: MALE_ALLERGIES_JSON
	 * @param maleAllergiesJson the MALE_ALLERGIES_JSON value
	 */
			public void setMaleAllergiesJson (java.lang.String maleAllergiesJson) {
			this.maleAllergiesJson = maleAllergiesJson;
	}



	/**
	 * Return the value associated with the column: MALE_LIFESTYLE_JSON
	 */

	public java.lang.String getMaleLifestyleJson () {
			return maleLifestyleJson;
	}



	/**
	 * Set the value related to the column: MALE_LIFESTYLE_JSON
	 * @param maleLifestyleJson the MALE_LIFESTYLE_JSON value
	 */
			public void setMaleLifestyleJson (java.lang.String maleLifestyleJson) {
			this.maleLifestyleJson = maleLifestyleJson;
	}



	/**
	 * Return the value associated with the column: MALE_FAMILY_HISTORY_JSON
	 */

	public java.lang.String getMaleFamilyHistoryJson () {
			return maleFamilyHistoryJson;
	}



	/**
	 * Set the value related to the column: MALE_FAMILY_HISTORY_JSON
	 * @param maleFamilyHistoryJson the MALE_FAMILY_HISTORY_JSON value
	 */
			public void setMaleFamilyHistoryJson (java.lang.String maleFamilyHistoryJson) {
			this.maleFamilyHistoryJson = maleFamilyHistoryJson;
	}



	/**
	 * Return the value associated with the column: ADMIN_AND_CONSENT_JSON
	 */

	public java.lang.String getAdminAndConsentJson () {
			return adminAndConsentJson;
	}



	/**
	 * Set the value related to the column: ADMIN_AND_CONSENT_JSON
	 * @param adminAndConsentJson the ADMIN_AND_CONSENT_JSON value
	 */
			public void setAdminAndConsentJson (java.lang.String adminAndConsentJson) {
			this.adminAndConsentJson = adminAndConsentJson;
	}



	/**
	 * Return the value associated with the column: ADDITIONAL_INFO_JSON
	 */

	public java.lang.String getAdditionalInfoJson () {
			return additionalInfoJson;
	}



	/**
	 * Set the value related to the column: ADDITIONAL_INFO_JSON
	 * @param additionalInfoJson the ADDITIONAL_INFO_JSON value
	 */
			public void setAdditionalInfoJson (java.lang.String additionalInfoJson) {
			this.additionalInfoJson = additionalInfoJson;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Couple)) return false;
		else {
			com.floreantpos.model.Couple couple = (com.floreantpos.model.Couple) obj;
			if (null == this.getId() || null == couple.getId()) return this == obj;
			else return (this.getId().equals(couple.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}