package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;

import com.floreantpos.model.StorageType;


/**
 * This is an object that contains data related to the CRYO_STORAGE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CRYO_STORAGE"
 */

public abstract class BaseCryoStorage  implements Comparable, Serializable {

	public static String REF = "CryoStorage"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_STORAGE_TYPE = "storageType"; //$NON-NLS-1$
	public static String PROP_PARENT_ID = "parentId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_CODE = "code"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_LOCATION = "location"; //$NON-NLS-1$
	public static String PROP_CAPACITY = "capacity"; //$NON-NLS-1$
	public static String PROP_CURRENT_COUNT = "currentCount"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_TEMPERATURE = "temperature"; //$NON-NLS-1$
	public static String PROP_LAST_MAINTENANCE_DATE = "lastMaintenanceDate"; //$NON-NLS-1$
	public static String PROP_NEXT_MAINTENANCE_DATE = "nextMaintenanceDate"; //$NON-NLS-1$
	public static String PROP_ALLOWED_CONTENT_TYPES = "allowedContentTypes"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_MANUFACTURER = "manufacturer"; //$NON-NLS-1$
	public static String PROP_MODEL = "model"; //$NON-NLS-1$
	public static String PROP_SERIAL_NUMBER = "serialNumber"; //$NON-NLS-1$
	public static String PROP_PURCHASE_DATE = "purchaseDate"; //$NON-NLS-1$
	public static String PROP_NOTES = "notes"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseCryoStorage () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCryoStorage (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseCryoStorage (
		java.lang.String id,
		StorageType storageType,
		java.lang.String name) {

		this.setId(id);
		this.setStorageType(storageType);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
		private java.lang.String outletId;
			private java.util.Date createdDate;
			private java.util.Date lastUpdateTime;
			private java.util.Date lastSyncTime;
			private java.lang.String properties;
			private java.lang.Boolean deleted;
			private StorageType storageType;
			private java.lang.String parentId;
			private java.lang.String name;
			private java.lang.String code;
			private java.lang.String description;
			private java.lang.String location;
			private java.lang.Integer capacity;
			private java.lang.Integer currentCount;
			private java.lang.String status;
			private java.lang.Double temperature;
			private java.util.Date lastMaintenanceDate;
			private java.util.Date nextMaintenanceDate;
			private java.lang.String allowedContentTypes;
			private java.lang.Integer sortOrder;
			private java.lang.String manufacturer;
			private java.lang.String model;
			private java.lang.String serialNumber;
			private java.util.Date purchaseDate;
			private java.lang.String notes;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
		return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
		public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
		return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
		public void setCreatedDate (java.util.Date createdDate) {
		this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
		return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
		public void setLastUpdateTime (java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
		return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
		public void setLastSyncTime (java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
		return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
		public void setProperties (java.lang.String properties) {
		this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
		}

	public java.lang.Boolean getDeleted () {
				return deleted == null ? Boolean.valueOf(false) : deleted;
		}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
		public void setDeleted (java.lang.Boolean deleted) {
		this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: STORAGE_TYPE
	 */

	public StorageType getStorageType () {
		return storageType;
	}



	/**
	 * Set the value related to the column: STORAGE_TYPE
	 * @param storageType the STORAGE_TYPE value
	 */
		public void setStorageType (StorageType storageType) {
		this.storageType = storageType;
	}



	/**
	 * Return the value associated with the column: PARENT_ID
	 */

	public java.lang.String getParentId () {
		return parentId;
	}



	/**
	 * Set the value related to the column: PARENT_ID
	 * @param parentId the PARENT_ID value
	 */
		public void setParentId (java.lang.String parentId) {
		this.parentId = parentId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
		return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
		public void setName (java.lang.String name) {
		this.name = name;
	}



	/**
	 * Return the value associated with the column: CODE
	 */

	public java.lang.String getCode () {
		return code;
	}



	/**
	 * Set the value related to the column: CODE
	 * @param code the CODE value
	 */
		public void setCode (java.lang.String code) {
		this.code = code;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
		return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
		public void setDescription (java.lang.String description) {
		this.description = description;
	}



	/**
	 * Return the value associated with the column: LOCATION
	 */

	public java.lang.String getLocation () {
		return location;
	}



	/**
	 * Set the value related to the column: LOCATION
	 * @param location the LOCATION value
	 */
		public void setLocation (java.lang.String location) {
		this.location = location;
	}



	/**
	 * Return the value associated with the column: CAPACITY
	 */

	public java.lang.Integer getCapacity () {
					return capacity == null ? Integer.valueOf(0) : capacity;
	}



	/**
	 * Set the value related to the column: CAPACITY
	 * @param capacity the CAPACITY value
	 */
		public void setCapacity (java.lang.Integer capacity) {
		this.capacity = capacity;
	}



	/**
	 * Return the value associated with the column: CURRENT_COUNT
	 */

	public java.lang.Integer getCurrentCount () {
					return currentCount == null ? Integer.valueOf(0) : currentCount;
	}



	/**
	 * Set the value related to the column: CURRENT_COUNT
	 * @param currentCount the CURRENT_COUNT value
	 */
		public void setCurrentCount (java.lang.Integer currentCount) {
		this.currentCount = currentCount;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
		return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
		public void setStatus (java.lang.String status) {
		this.status = status;
	}



	/**
	 * Return the value associated with the column: TEMPERATURE
	 */

	public java.lang.Double getTemperature () {
		return temperature;
	}



	/**
	 * Set the value related to the column: TEMPERATURE
	 * @param temperature the TEMPERATURE value
	 */
		public void setTemperature (java.lang.Double temperature) {
		this.temperature = temperature;
	}



	/**
	 * Return the value associated with the column: LAST_MAINTENANCE_DATE
	 */

	public java.util.Date getLastMaintenanceDate () {
		return lastMaintenanceDate;
	}



	/**
	 * Set the value related to the column: LAST_MAINTENANCE_DATE
	 * @param lastMaintenanceDate the LAST_MAINTENANCE_DATE value
	 */
		public void setLastMaintenanceDate (java.util.Date lastMaintenanceDate) {
		this.lastMaintenanceDate = lastMaintenanceDate;
	}



	/**
	 * Return the value associated with the column: NEXT_MAINTENANCE_DATE
	 */

	public java.util.Date getNextMaintenanceDate () {
		return nextMaintenanceDate;
	}



	/**
	 * Set the value related to the column: NEXT_MAINTENANCE_DATE
	 * @param nextMaintenanceDate the NEXT_MAINTENANCE_DATE value
	 */
		public void setNextMaintenanceDate (java.util.Date nextMaintenanceDate) {
		this.nextMaintenanceDate = nextMaintenanceDate;
	}



	/**
	 * Return the value associated with the column: ALLOWED_CONTENT_TYPES
	 */

	public java.lang.String getAllowedContentTypes () {
		return allowedContentTypes;
	}



	/**
	 * Set the value related to the column: ALLOWED_CONTENT_TYPES
	 * @param allowedContentTypes the ALLOWED_CONTENT_TYPES value
	 */
		public void setAllowedContentTypes (java.lang.String allowedContentTypes) {
		this.allowedContentTypes = allowedContentTypes;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
					return sortOrder == null ? Integer.valueOf(0) : sortOrder;
	}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
		public void setSortOrder (java.lang.Integer sortOrder) {
		this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: MANUFACTURER
	 */

	public java.lang.String getManufacturer () {
		return manufacturer;
	}



	/**
	 * Set the value related to the column: MANUFACTURER
	 * @param manufacturer the MANUFACTURER value
	 */
		public void setManufacturer (java.lang.String manufacturer) {
		this.manufacturer = manufacturer;
	}



	/**
	 * Return the value associated with the column: MODEL
	 */

	public java.lang.String getModel () {
		return model;
	}



	/**
	 * Set the value related to the column: MODEL
	 * @param model the MODEL value
	 */
		public void setModel (java.lang.String model) {
		this.model = model;
	}



	/**
	 * Return the value associated with the column: SERIAL_NUMBER
	 */

	public java.lang.String getSerialNumber () {
		return serialNumber;
	}



	/**
	 * Set the value related to the column: SERIAL_NUMBER
	 * @param serialNumber the SERIAL_NUMBER value
	 */
		public void setSerialNumber (java.lang.String serialNumber) {
		this.serialNumber = serialNumber;
	}



	/**
	 * Return the value associated with the column: PURCHASE_DATE
	 */

	public java.util.Date getPurchaseDate () {
		return purchaseDate;
	}



	/**
	 * Set the value related to the column: PURCHASE_DATE
	 * @param purchaseDate the PURCHASE_DATE value
	 */
		public void setPurchaseDate (java.util.Date purchaseDate) {
		this.purchaseDate = purchaseDate;
	}



	/**
	 * Return the value associated with the column: NOTES
	 */

	public java.lang.String getNotes () {
		return notes;
	}



	/**
	 * Set the value related to the column: NOTES
	 * @param notes the NOTES value
	 */
		public void setNotes (java.lang.String notes) {
		this.notes = notes;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.CryoStorage)) return false;
		else {
			com.floreantpos.model.CryoStorage cryoStorage = (com.floreantpos.model.CryoStorage) obj;
			if (null == this.getId() || null == cryoStorage.getId()) return this == obj;
			else return (this.getId().equals(cryoStorage.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}
