package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the CYCLE_PLAN table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CYCLE_PLAN"
 */

public abstract class BaseCyclePlan  implements Comparable, Serializable {

	public static String REF = "CyclePlan"; //$NON-NLS-1$
	public static String PROP_DOCTOR_NAME = "doctorName"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_RETRIEVAL_DATE = "retrievalDate"; //$NON-NLS-1$
	public static String PROP_PROTOCOL_NAME = "protocolName"; //$NON-NLS-1$
	public static String PROP_EXPECTED_END_DATE = "expectedEndDate"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_EMBRYOS_CREATED = "numberOfEmbryosCreated"; //$NON-NLS-1$
	public static String PROP_PROTOCOL_TEMPLATE_ID = "protocolTemplateId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_MATURE_EGGS = "numberOfMatureEggs"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_START_DATE = "startDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CYCLE_STATUS = "cycleStatus"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_COUPLE_ID = "coupleId"; //$NON-NLS-1$
	public static String PROP_SPERM_SAMPLE_ID = "spermSampleId"; //$NON-NLS-1$
	public static String PROP_COMPLETION_DATE = "completionDate"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_EGGS_RETRIEVED = "numberOfEggsRetrieved"; //$NON-NLS-1$
	public static String PROP_NOTES = "notes"; //$NON-NLS-1$


	// constructors
	public BaseCyclePlan () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCyclePlan (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseCyclePlan (
		java.lang.String id,
		java.lang.String coupleId) {

		this.setId(id);
		this.setCoupleId(coupleId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String coupleId;
				private java.lang.String spermSampleId;
				private java.lang.String protocolTemplateId;
				private java.lang.String protocolName;
				private java.lang.String doctorId;
				private java.lang.String doctorName;
				private java.lang.String cycleStatus;
				private java.util.Date startDate;
				private java.util.Date expectedEndDate;
				private java.util.Date retrievalDate;
				private java.util.Date completionDate;
				private java.lang.Integer numberOfEggsRetrieved;
				private java.lang.Integer numberOfMatureEggs;
				private java.lang.Integer numberOfEmbryosCreated;
				private java.lang.String notes;
	
	// collections
	private java.util.Set<com.floreantpos.model.Embryo> embryos;
	private java.util.Set<com.floreantpos.model.ProtocolPhase> protocolPhases;
	private java.util.Set<com.floreantpos.model.CycleStageLog> cycleStageLogs;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: COUPLE_ID
	 */

	public java.lang.String getCoupleId () {
			return coupleId;
	}



	/**
	 * Set the value related to the column: COUPLE_ID
	 * @param coupleId the COUPLE_ID value
	 */
			public void setCoupleId (java.lang.String coupleId) {
			this.coupleId = coupleId;
	}



	/**
	 * Return the value associated with the column: SPERM_SAMPLE_ID
	 */

	public java.lang.String getSpermSampleId () {
			return spermSampleId;
	}



	/**
	 * Set the value related to the column: SPERM_SAMPLE_ID
	 * @param spermSampleId the SPERM_SAMPLE_ID value
	 */
			public void setSpermSampleId (java.lang.String spermSampleId) {
			this.spermSampleId = spermSampleId;
	}



	/**
	 * Return the value associated with the column: PROTOCOL_TEMPLATE_ID
	 */

	public java.lang.String getProtocolTemplateId () {
			return protocolTemplateId;
	}



	/**
	 * Set the value related to the column: PROTOCOL_TEMPLATE_ID
	 * @param protocolTemplateId the PROTOCOL_TEMPLATE_ID value
	 */
			public void setProtocolTemplateId (java.lang.String protocolTemplateId) {
			this.protocolTemplateId = protocolTemplateId;
	}



	/**
	 * Return the value associated with the column: PROTOCOL_NAME
	 */

	public java.lang.String getProtocolName () {
			return protocolName;
	}



	/**
	 * Set the value related to the column: PROTOCOL_NAME
	 * @param protocolName the PROTOCOL_NAME value
	 */
			public void setProtocolName (java.lang.String protocolName) {
			this.protocolName = protocolName;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_NAME
	 */

	public java.lang.String getDoctorName () {
			return doctorName;
	}



	/**
	 * Set the value related to the column: DOCTOR_NAME
	 * @param doctorName the DOCTOR_NAME value
	 */
			public void setDoctorName (java.lang.String doctorName) {
			this.doctorName = doctorName;
	}



	/**
	 * Return the value associated with the column: CYCLE_STATUS
	 */

	public java.lang.String getCycleStatus () {
			return cycleStatus;
	}



	/**
	 * Set the value related to the column: CYCLE_STATUS
	 * @param cycleStatus the CYCLE_STATUS value
	 */
			public void setCycleStatus (java.lang.String cycleStatus) {
			this.cycleStatus = cycleStatus;
	}



	/**
	 * Return the value associated with the column: START_DATE
	 */

	public java.util.Date getStartDate () {
			return startDate;
	}



	/**
	 * Set the value related to the column: START_DATE
	 * @param startDate the START_DATE value
	 */
			public void setStartDate (java.util.Date startDate) {
			this.startDate = startDate;
	}



	/**
	 * Return the value associated with the column: EXPECTED_END_DATE
	 */

	public java.util.Date getExpectedEndDate () {
			return expectedEndDate;
	}



	/**
	 * Set the value related to the column: EXPECTED_END_DATE
	 * @param expectedEndDate the EXPECTED_END_DATE value
	 */
			public void setExpectedEndDate (java.util.Date expectedEndDate) {
			this.expectedEndDate = expectedEndDate;
	}



	/**
	 * Return the value associated with the column: RETRIEVAL_DATE
	 */

	public java.util.Date getRetrievalDate () {
			return retrievalDate;
	}



	/**
	 * Set the value related to the column: RETRIEVAL_DATE
	 * @param retrievalDate the RETRIEVAL_DATE value
	 */
			public void setRetrievalDate (java.util.Date retrievalDate) {
			this.retrievalDate = retrievalDate;
	}



	/**
	 * Return the value associated with the column: COMPLETION_DATE
	 */

	public java.util.Date getCompletionDate () {
			return completionDate;
	}



	/**
	 * Set the value related to the column: COMPLETION_DATE
	 * @param completionDate the COMPLETION_DATE value
	 */
			public void setCompletionDate (java.util.Date completionDate) {
			this.completionDate = completionDate;
	}



	/**
	 * Return the value associated with the column: EGGS_RETRIEVED
	 */

	public java.lang.Integer getNumberOfEggsRetrieved () {
						return numberOfEggsRetrieved == null ? Integer.valueOf(0) : numberOfEggsRetrieved;
		}



	/**
	 * Set the value related to the column: EGGS_RETRIEVED
	 * @param numberOfEggsRetrieved the EGGS_RETRIEVED value
	 */
			public void setNumberOfEggsRetrieved (java.lang.Integer numberOfEggsRetrieved) {
			this.numberOfEggsRetrieved = numberOfEggsRetrieved;
	}



	/**
	 * Return the value associated with the column: MATURE_EGGS
	 */

	public java.lang.Integer getNumberOfMatureEggs () {
						return numberOfMatureEggs == null ? Integer.valueOf(0) : numberOfMatureEggs;
		}



	/**
	 * Set the value related to the column: MATURE_EGGS
	 * @param numberOfMatureEggs the MATURE_EGGS value
	 */
			public void setNumberOfMatureEggs (java.lang.Integer numberOfMatureEggs) {
			this.numberOfMatureEggs = numberOfMatureEggs;
	}



	/**
	 * Return the value associated with the column: EMBRYOS_CREATED
	 */

	public java.lang.Integer getNumberOfEmbryosCreated () {
						return numberOfEmbryosCreated == null ? Integer.valueOf(0) : numberOfEmbryosCreated;
		}



	/**
	 * Set the value related to the column: EMBRYOS_CREATED
	 * @param numberOfEmbryosCreated the EMBRYOS_CREATED value
	 */
			public void setNumberOfEmbryosCreated (java.lang.Integer numberOfEmbryosCreated) {
			this.numberOfEmbryosCreated = numberOfEmbryosCreated;
	}



	/**
	 * Return the value associated with the column: NOTES
	 */

	public java.lang.String getNotes () {
			return notes;
	}



	/**
	 * Set the value related to the column: NOTES
	 * @param notes the NOTES value
	 */
			public void setNotes (java.lang.String notes) {
			this.notes = notes;
	}



	/**
	 * Return the value associated with the column: embryos
	 */

	public java.util.Set<com.floreantpos.model.Embryo> getEmbryos () {
			return embryos;
	}



	/**
	 * Set the value related to the column: embryos
	 * @param embryos the embryos value
	 */
			public void setEmbryos (java.util.Set<com.floreantpos.model.Embryo> embryos) {
			this.embryos = embryos;
	}

	public void addToembryos (com.floreantpos.model.Embryo embryo) {
		if (null == getEmbryos()) setEmbryos(new java.util.TreeSet<com.floreantpos.model.Embryo>());
		getEmbryos().add(embryo);
	}



	/**
	 * Return the value associated with the column: protocolPhases
	 */

	public java.util.Set<com.floreantpos.model.ProtocolPhase> getProtocolPhases () {
			return protocolPhases;
	}



	/**
	 * Set the value related to the column: protocolPhases
	 * @param protocolPhases the protocolPhases value
	 */
			public void setProtocolPhases (java.util.Set<com.floreantpos.model.ProtocolPhase> protocolPhases) {
			this.protocolPhases = protocolPhases;
	}

	public void addToprotocolPhases (com.floreantpos.model.ProtocolPhase protocolPhase) {
		if (null == getProtocolPhases()) setProtocolPhases(new java.util.TreeSet<com.floreantpos.model.ProtocolPhase>());
		getProtocolPhases().add(protocolPhase);
	}

	/**
	 * Return the value associated with the column: cycleStageLogs
	 */
	public java.util.Set<com.floreantpos.model.CycleStageLog> getCycleStageLogs () {
		return cycleStageLogs;
	}

	/**
	 * Set the value related to the column: cycleStageLogs
	 * @param cycleStageLogs the cycleStageLogs value
	 */
		public void setCycleStageLogs (java.util.Set<com.floreantpos.model.CycleStageLog> cycleStageLogs) {
		this.cycleStageLogs = cycleStageLogs;
	}

	public void addTocycleStageLogs (com.floreantpos.model.CycleStageLog cycleStageLog) {
		if (null == getCycleStageLogs()) setCycleStageLogs(new java.util.TreeSet<com.floreantpos.model.CycleStageLog>());
		getCycleStageLogs().add(cycleStageLog);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.CyclePlan)) return false;
		else {
			com.floreantpos.model.CyclePlan cyclePlan = (com.floreantpos.model.CyclePlan) obj;
			if (null == this.getId() || null == cyclePlan.getId()) return this == obj;
			else return (this.getId().equals(cyclePlan.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}