package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the CYCLE_STAGE_LOG table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CYCLE_STAGE_LOG"
 */

public abstract class BaseCycleStageLog  implements Comparable, Serializable {

	public static String REF = "CycleStageLog"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_STAGE_NAME = "stageName"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CYCLE_PLAN = "cyclePlan"; //$NON-NLS-1$
	public static String PROP_ENTITY_TYPE = "entityType"; //$NON-NLS-1$
	public static String PROP_ENTITY_ID = "entityId"; //$NON-NLS-1$
	public static String PROP_ACTION_NAME = "actionName"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseCycleStageLog () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCycleStageLog (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String entityType;
				private java.lang.String entityId;
				private java.lang.String performerId;
				private java.lang.String performerName;
				private java.lang.String stageName;
				private java.lang.String actionName;
				private java.lang.String note;

	// many-to-one
	private com.floreantpos.model.CyclePlan cyclePlan;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */

	public java.lang.String getPerformerId () {
			return performerId;
	}



	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
			public void setPerformerId (java.lang.String performerId) {
			this.performerId = performerId;
	}



	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */

	public java.lang.String getPerformerName () {
			return performerName;
	}



	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
			public void setPerformerName (java.lang.String performerName) {
			this.performerName = performerName;
	}



	/**
	 * Return the value associated with the column: STAGE_NAME
	 */

	public java.lang.String getStageName () {
			return stageName;
	}



	/**
	 * Set the value related to the column: STAGE_NAME
	 * @param stageName the STAGE_NAME value
	 */
			public void setStageName (java.lang.String stageName) {
			this.stageName = stageName;
	}



	/**
	 * Return the value associated with the column: ACTION_NAME
	 */

	public java.lang.String getActionName () {
			return actionName;
	}



	/**
	 * Set the value related to the column: ACTION_NAME
	 * @param actionName the ACTION_NAME value
	 */
			public void setActionName (java.lang.String actionName) {
			this.actionName = actionName;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: ENTITY_TYPE
	 */

	public java.lang.String getEntityType () {
			return entityType;
	}



	/**
	 * Set the value related to the column: ENTITY_TYPE
	 * @param entityType the ENTITY_TYPE value
	 */
			public void setEntityType (java.lang.String entityType) {
			this.entityType = entityType;
	}



	/**
	 * Return the value associated with the column: ENTITY_ID
	 */

	public java.lang.String getEntityId () {
			return entityId;
	}



	/**
	 * Set the value related to the column: ENTITY_ID
	 * @param entityId the ENTITY_ID value
	 */
			public void setEntityId (java.lang.String entityId) {
			this.entityId = entityId;
	}



	/**
	 * Return the value associated with the column: CYCLE_PLAN_ID
	 */

	public com.floreantpos.model.CyclePlan getCyclePlan () {
		return cyclePlan;
	}



	/**
	 * Set the value related to the column: CYCLE_PLAN_ID
	 * @param cyclePlan the CYCLE_PLAN_ID value
	 */
		public void setCyclePlan (com.floreantpos.model.CyclePlan cyclePlan) {
		this.cyclePlan = cyclePlan;
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.CycleStageLog)) return false;
		else {
			com.floreantpos.model.CycleStageLog cycleStageLog = (com.floreantpos.model.CycleStageLog) obj;
			if (null == this.getId() || null == cycleStageLog.getId()) return this == obj;
			else return (this.getId().equals(cycleStageLog.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}