package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the EMBRYO table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="EMBRYO"
 */

public abstract class BaseEmbryo  implements Comparable, Serializable {

	public static String REF = "Embryo"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CANE_NUMBER = "caneNumber"; //$NON-NLS-1$
	public static String PROP_THAW_DATE = "thawDate"; //$NON-NLS-1$
	public static String PROP_TRANSFERRED = "transferred"; //$NON-NLS-1$
	public static String PROP_GRADE = "grade"; //$NON-NLS-1$
	public static String PROP_SURVIVAL_AFTER_THAW = "survivalAfterThaw"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_FROZEN = "frozen"; //$NON-NLS-1$
	public static String PROP_BIOPSY_STATUS = "biopsyStatus"; //$NON-NLS-1$
	public static String PROP_CYCLE_PLAN = "cyclePlan"; //$NON-NLS-1$
	public static String PROP_TANK_NUMBER = "tankNumber"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_DAY_OF_DEVELOPMENT = "dayOfDevelopment"; //$NON-NLS-1$
	public static String PROP_TRANSFER_DATE = "transferDate"; //$NON-NLS-1$
	public static String PROP_PREPARE_BY_ID = "prepareById"; //$NON-NLS-1$
	public static String PROP_TRANSFER_ID = "transferId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_SPERM_SAMPLE_ID = "spermSampleId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_FREEZE_DATE = "freezeDate"; //$NON-NLS-1$
	public static String PROP_STORAGE_LOCATION = "storageLocation"; //$NON-NLS-1$
	public static String PROP_STORAGE_CONTAINER_ID = "storageContainerId"; //$NON-NLS-1$


	// constructors
	public BaseEmbryo () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseEmbryo (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseEmbryo (
		java.lang.String id,
		com.floreantpos.model.CyclePlan cyclePlan) {

		this.setId(id);
		this.setCyclePlan(cyclePlan);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String spermSampleId;
				private java.lang.String prepareById;
				private java.lang.Integer dayOfDevelopment;
				private java.lang.String grade;
				private java.lang.String status;
				private java.lang.String biopsyStatus;
				private java.lang.Boolean transferred;
				private java.lang.String transferId;
				private java.util.Date transferDate;
				private java.lang.Boolean frozen;
				private java.util.Date freezeDate;
				private java.lang.String storageLocation;
				private java.lang.String tankNumber;
				private java.lang.String caneNumber;
				private java.util.Date thawDate;
				private java.lang.Boolean survivalAfterThaw;
		private java.lang.String storageContainerId;

	// many to one
	private com.floreantpos.model.CyclePlan cyclePlan;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: SPERM_SAMPLE_ID
	 */

	public java.lang.String getSpermSampleId () {
			return spermSampleId;
	}



	/**
	 * Set the value related to the column: SPERM_SAMPLE_ID
	 * @param spermSampleId the SPERM_SAMPLE_ID value
	 */
			public void setSpermSampleId (java.lang.String spermSampleId) {
			this.spermSampleId = spermSampleId;
	}



	/**
	 * Return the value associated with the column: PREPARE_BY_USER
	 */

	public java.lang.String getPrepareById () {
			return prepareById;
	}



	/**
	 * Set the value related to the column: PREPARE_BY_USER
	 * @param prepareById the PREPARE_BY_USER value
	 */
			public void setPrepareById (java.lang.String prepareById) {
			this.prepareById = prepareById;
	}



	/**
	 * Return the value associated with the column: DAY_OF_DEVELOPMENT
	 */

	public java.lang.Integer getDayOfDevelopment () {
						return dayOfDevelopment == null ? Integer.valueOf(0) : dayOfDevelopment;
		}



	/**
	 * Set the value related to the column: DAY_OF_DEVELOPMENT
	 * @param dayOfDevelopment the DAY_OF_DEVELOPMENT value
	 */
			public void setDayOfDevelopment (java.lang.Integer dayOfDevelopment) {
			this.dayOfDevelopment = dayOfDevelopment;
	}



	/**
	 * Return the value associated with the column: GRADE
	 */

	public java.lang.String getGrade () {
			return grade;
	}



	/**
	 * Set the value related to the column: GRADE
	 * @param grade the GRADE value
	 */
			public void setGrade (java.lang.String grade) {
			this.grade = grade;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: BIOPSY_STATUS
	 */

	public java.lang.String getBiopsyStatus () {
			return biopsyStatus;
	}



	/**
	 * Set the value related to the column: BIOPSY_STATUS
	 * @param biopsyStatus the BIOPSY_STATUS value
	 */
			public void setBiopsyStatus (java.lang.String biopsyStatus) {
			this.biopsyStatus = biopsyStatus;
	}



	/**
	 * Return the value associated with the column: TRANSFERRED
	 */

	public java.lang.Boolean isTransferred () {
					return transferred == null ? Boolean.FALSE : transferred;
		}

	public java.lang.Boolean getTransferred () {
				return transferred == null ? Boolean.FALSE : transferred;
			}


	/**
	 * Set the value related to the column: TRANSFERRED
	 * @param transferred the TRANSFERRED value
	 */
			public void setTransferred (java.lang.Boolean transferred) {
			this.transferred = transferred;
	}



	/**
	 * Return the value associated with the column: TRANSFER_ID
	 */

	public java.lang.String getTransferId () {
			return transferId;
	}



	/**
	 * Set the value related to the column: TRANSFER_ID
	 * @param transferId the TRANSFER_ID value
	 */
			public void setTransferId (java.lang.String transferId) {
			this.transferId = transferId;
	}



	/**
	 * Return the value associated with the column: TRANSFER_DATE
	 */

	public java.util.Date getTransferDate () {
			return transferDate;
	}



	/**
	 * Set the value related to the column: TRANSFER_DATE
	 * @param transferDate the TRANSFER_DATE value
	 */
			public void setTransferDate (java.util.Date transferDate) {
			this.transferDate = transferDate;
	}



	/**
	 * Return the value associated with the column: FROZEN
	 */

	public java.lang.Boolean isFrozen () {
					return frozen == null ? Boolean.FALSE : frozen;
		}

	public java.lang.Boolean getFrozen () {
				return frozen == null ? Boolean.FALSE : frozen;
			}


	/**
	 * Set the value related to the column: FROZEN
	 * @param frozen the FROZEN value
	 */
			public void setFrozen (java.lang.Boolean frozen) {
			this.frozen = frozen;
	}



	/**
	 * Return the value associated with the column: FREEZE_DATE
	 */

	public java.util.Date getFreezeDate () {
			return freezeDate;
	}



	/**
	 * Set the value related to the column: FREEZE_DATE
	 * @param freezeDate the FREEZE_DATE value
	 */
			public void setFreezeDate (java.util.Date freezeDate) {
			this.freezeDate = freezeDate;
	}



	/**
	 * Return the value associated with the column: STORAGE_LOCATION
	 */

	public java.lang.String getStorageLocation () {
			return storageLocation;
	}



	/**
	 * Set the value related to the column: STORAGE_LOCATION
	 * @param storageLocation the STORAGE_LOCATION value
	 */
			public void setStorageLocation (java.lang.String storageLocation) {
			this.storageLocation = storageLocation;
	}



	/**
	 * Return the value associated with the column: TANK_NUMBER
	 */

	public java.lang.String getTankNumber () {
			return tankNumber;
	}



	/**
	 * Set the value related to the column: TANK_NUMBER
	 * @param tankNumber the TANK_NUMBER value
	 */
			public void setTankNumber (java.lang.String tankNumber) {
			this.tankNumber = tankNumber;
	}



	/**
	 * Return the value associated with the column: CANE_NUMBER
	 */

	public java.lang.String getCaneNumber () {
			return caneNumber;
	}



	/**
	 * Set the value related to the column: CANE_NUMBER
	 * @param caneNumber the CANE_NUMBER value
	 */
			public void setCaneNumber (java.lang.String caneNumber) {
			this.caneNumber = caneNumber;
	}



	/**
	 * Return the value associated with the column: THAW_DATE
	 */

	public java.util.Date getThawDate () {
			return thawDate;
	}



	/**
	 * Set the value related to the column: THAW_DATE
	 * @param thawDate the THAW_DATE value
	 */
			public void setThawDate (java.util.Date thawDate) {
			this.thawDate = thawDate;
	}



	/**
	 * Return the value associated with the column: SURVIVAL_AFTER_THAW
	 */

	public java.lang.Boolean isSurvivalAfterThaw () {
					return survivalAfterThaw == null ? Boolean.FALSE : survivalAfterThaw;
		}

	public java.lang.Boolean getSurvivalAfterThaw () {
				return survivalAfterThaw == null ? Boolean.FALSE : survivalAfterThaw;
			}


	/**
	 * Set the value related to the column: SURVIVAL_AFTER_THAW
	 * @param survivalAfterThaw the SURVIVAL_AFTER_THAW value
	 */
			public void setSurvivalAfterThaw (java.lang.Boolean survivalAfterThaw) {
			this.survivalAfterThaw = survivalAfterThaw;
	}



	/**
	 * Return the value associated with the column: CYCLE_PLAN_ID
	 */

	public com.floreantpos.model.CyclePlan getCyclePlan () {
			return cyclePlan;
	}



	/**
	 * Set the value related to the column: CYCLE_PLAN_ID
	 * @param cyclePlan the CYCLE_PLAN_ID value
	 */
			public void setCyclePlan (com.floreantpos.model.CyclePlan cyclePlan) {
			this.cyclePlan = cyclePlan;
	}



	/**
	 * Return the value associated with the column: STORAGE_CONTAINER_ID
	 */

	public java.lang.String getStorageContainerId () {
		return storageContainerId;
	}



	/**
	 * Set the value related to the column: STORAGE_CONTAINER_ID
	 * @param storageContainerId the STORAGE_CONTAINER_ID value
	 */
		public void setStorageContainerId (java.lang.String storageContainerId) {
		this.storageContainerId = storageContainerId;
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Embryo)) return false;
		else {
			com.floreantpos.model.Embryo embryo = (com.floreantpos.model.Embryo) obj;
			if (null == this.getId() || null == embryo.getId()) return this == obj;
			else return (this.getId().equals(embryo.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}