package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the EMBRYO_TRANSFER table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="EMBRYO_TRANSFER"
 */

public abstract class BaseEmbryoTransfer  implements Comparable, Serializable {

	public static String REF = "EmbryoTransfer"; //$NON-NLS-1$
	public static String PROP_CATHETER_TYPE = "catheterType"; //$NON-NLS-1$
	public static String PROP_SECOND_BETA_HCG_DATE = "secondBetaHcgDate"; //$NON-NLS-1$
	public static String PROP_FIRST_BETA_HCG_VALUE = "firstBetaHcgValue"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_DELIVERY_DATE = "deliveryDate"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_ENDOMETRIUM_THICKNESS = "endometriumThickness"; //$NON-NLS-1$
	public static String PROP_TRANSFER_NOTES = "transferNotes"; //$NON-NLS-1$
	public static String PROP_BABIES_COUNT = "babiesCount"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_EMBRYOS_TRANSFERRED = "numberOfEmbryosTransferred"; //$NON-NLS-1$
	public static String PROP_TRANSFER_DIFFICULTY = "transferDifficulty"; //$NON-NLS-1$
	public static String PROP_SECOND_BETA_HCG_VALUE = "secondBetaHcgValue"; //$NON-NLS-1$
	public static String PROP_TRANSFER_DATE = "transferDate"; //$NON-NLS-1$
	public static String PROP_FIRST_BETA_HCG_DATE = "firstBetaHcgDate"; //$NON-NLS-1$
	public static String PROP_GESTATIONAL_WEEKS = "gestationalWeeks"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_COUPLE_ID = "coupleId"; //$NON-NLS-1$
	public static String PROP_DELIVERY_TYPE = "deliveryType"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_FIRST_ULTRASOUND_DATE = "firstUltrasoundDate"; //$NON-NLS-1$
	public static String PROP_GESTATIONAL_SACS_COUNT = "gestationalSacsCount"; //$NON-NLS-1$
	public static String PROP_TRANSFER_TYPE = "transferType"; //$NON-NLS-1$
	public static String PROP_DELIVERY_NOTES = "deliveryNotes"; //$NON-NLS-1$
	public static String PROP_FETAL_HEARTBEATS_COUNT = "fetalHeartbeatsCount"; //$NON-NLS-1$
	public static String PROP_CYCLE_PLAN_ID = "cyclePlanId"; //$NON-NLS-1$
	public static String PROP_OUTCOME = "outcome"; //$NON-NLS-1$
	public static String PROP_OUTCOME_NOTES = "outcomeNotes"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$
	public static String PROP_TRANSFER_TECHNIQUE = "transferTechnique"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_OUTCOME_DATE = "outcomeDate"; //$NON-NLS-1$


	// constructors
	public BaseEmbryoTransfer () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseEmbryoTransfer (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseEmbryoTransfer (
		java.lang.String id,
		java.lang.String coupleId,
		java.lang.String cyclePlanId) {

		this.setId(id);
		this.setCoupleId(coupleId);
		this.setCyclePlanId(cyclePlanId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String coupleId;
				private java.lang.String cyclePlanId;
				private java.lang.String transferType;
				private java.util.Date transferDate;
				private java.lang.Integer numberOfEmbryosTransferred;
				private java.lang.String performerId;
				private java.lang.String performerName;
				private java.lang.String transferTechnique;
				private java.lang.String catheterType;
				private double endometriumThickness;
				private java.lang.String transferDifficulty;
				private java.lang.String transferNotes;
				private java.util.Date firstBetaHcgDate;
				private double firstBetaHcgValue;
				private java.util.Date secondBetaHcgDate;
				private double secondBetaHcgValue;
				private java.util.Date firstUltrasoundDate;
				private java.lang.Integer gestationalSacsCount;
				private java.lang.Integer fetalHeartbeatsCount;
				private java.lang.String outcome;
				private java.util.Date outcomeDate;
				private java.lang.String outcomeNotes;
				private java.util.Date deliveryDate;
				private java.lang.String deliveryType;
				private java.lang.Integer gestationalWeeks;
				private java.lang.Integer babiesCount;
				private java.lang.String deliveryNotes;
	
	// collections
	private java.util.Set<com.floreantpos.model.Embryo> embryos;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: COUPLE_ID
	 */

	public java.lang.String getCoupleId () {
			return coupleId;
	}



	/**
	 * Set the value related to the column: COUPLE_ID
	 * @param coupleId the COUPLE_ID value
	 */
			public void setCoupleId (java.lang.String coupleId) {
			this.coupleId = coupleId;
	}



	/**
	 * Return the value associated with the column: CYCLE_PLAN_ID
	 */

	public java.lang.String getCyclePlanId () {
			return cyclePlanId;
	}



	/**
	 * Set the value related to the column: CYCLE_PLAN_ID
	 * @param cyclePlanId the CYCLE_PLAN_ID value
	 */
			public void setCyclePlanId (java.lang.String cyclePlanId) {
			this.cyclePlanId = cyclePlanId;
	}



	/**
	 * Return the value associated with the column: TRANSFER_TYPE
	 */

	public java.lang.String getTransferType () {
			return transferType;
	}



	/**
	 * Set the value related to the column: TRANSFER_TYPE
	 * @param transferType the TRANSFER_TYPE value
	 */
			public void setTransferType (java.lang.String transferType) {
			this.transferType = transferType;
	}



	/**
	 * Return the value associated with the column: TRANSFER_DATE
	 */

	public java.util.Date getTransferDate () {
			return transferDate;
	}



	/**
	 * Set the value related to the column: TRANSFER_DATE
	 * @param transferDate the TRANSFER_DATE value
	 */
			public void setTransferDate (java.util.Date transferDate) {
			this.transferDate = transferDate;
	}



	/**
	 * Return the value associated with the column: EMBRYOS_COUNT
	 */

	public java.lang.Integer getNumberOfEmbryosTransferred () {
						return numberOfEmbryosTransferred == null ? Integer.valueOf(0) : numberOfEmbryosTransferred;
		}



	/**
	 * Set the value related to the column: EMBRYOS_COUNT
	 * @param numberOfEmbryosTransferred the EMBRYOS_COUNT value
	 */
			public void setNumberOfEmbryosTransferred (java.lang.Integer numberOfEmbryosTransferred) {
			this.numberOfEmbryosTransferred = numberOfEmbryosTransferred;
	}



	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */

	public java.lang.String getPerformerId () {
			return performerId;
	}



	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
			public void setPerformerId (java.lang.String performerId) {
			this.performerId = performerId;
	}



	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */

	public java.lang.String getPerformerName () {
			return performerName;
	}



	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
			public void setPerformerName (java.lang.String performerName) {
			this.performerName = performerName;
	}



	/**
	 * Return the value associated with the column: TRANSFER_TECHNIQUE
	 */

	public java.lang.String getTransferTechnique () {
			return transferTechnique;
	}



	/**
	 * Set the value related to the column: TRANSFER_TECHNIQUE
	 * @param transferTechnique the TRANSFER_TECHNIQUE value
	 */
			public void setTransferTechnique (java.lang.String transferTechnique) {
			this.transferTechnique = transferTechnique;
	}



	/**
	 * Return the value associated with the column: CATHETER_TYPE
	 */

	public java.lang.String getCatheterType () {
			return catheterType;
	}



	/**
	 * Set the value related to the column: CATHETER_TYPE
	 * @param catheterType the CATHETER_TYPE value
	 */
			public void setCatheterType (java.lang.String catheterType) {
			this.catheterType = catheterType;
	}



	/**
	 * Return the value associated with the column: ENDOMETRIUM_THICKNESS
	 */

	public double getEndometriumThickness () {
			return endometriumThickness;
	}



	/**
	 * Set the value related to the column: ENDOMETRIUM_THICKNESS
	 * @param endometriumThickness the ENDOMETRIUM_THICKNESS value
	 */
			public void setEndometriumThickness (double endometriumThickness) {
			this.endometriumThickness = endometriumThickness;
	}



	/**
	 * Return the value associated with the column: TRANSFER_DIFFICULTY
	 */

	public java.lang.String getTransferDifficulty () {
			return transferDifficulty;
	}



	/**
	 * Set the value related to the column: TRANSFER_DIFFICULTY
	 * @param transferDifficulty the TRANSFER_DIFFICULTY value
	 */
			public void setTransferDifficulty (java.lang.String transferDifficulty) {
			this.transferDifficulty = transferDifficulty;
	}



	/**
	 * Return the value associated with the column: TRANSFER_NOTES
	 */

	public java.lang.String getTransferNotes () {
			return transferNotes;
	}



	/**
	 * Set the value related to the column: TRANSFER_NOTES
	 * @param transferNotes the TRANSFER_NOTES value
	 */
			public void setTransferNotes (java.lang.String transferNotes) {
			this.transferNotes = transferNotes;
	}



	/**
	 * Return the value associated with the column: FIRST_BETA_HCG_DATE
	 */

	public java.util.Date getFirstBetaHcgDate () {
			return firstBetaHcgDate;
	}



	/**
	 * Set the value related to the column: FIRST_BETA_HCG_DATE
	 * @param firstBetaHcgDate the FIRST_BETA_HCG_DATE value
	 */
			public void setFirstBetaHcgDate (java.util.Date firstBetaHcgDate) {
			this.firstBetaHcgDate = firstBetaHcgDate;
	}



	/**
	 * Return the value associated with the column: FIRST_BETA_HCG_VALUE
	 */

	public double getFirstBetaHcgValue () {
			return firstBetaHcgValue;
	}



	/**
	 * Set the value related to the column: FIRST_BETA_HCG_VALUE
	 * @param firstBetaHcgValue the FIRST_BETA_HCG_VALUE value
	 */
			public void setFirstBetaHcgValue (double firstBetaHcgValue) {
			this.firstBetaHcgValue = firstBetaHcgValue;
	}



	/**
	 * Return the value associated with the column: SECOND_BETA_HCG_DATE
	 */

	public java.util.Date getSecondBetaHcgDate () {
			return secondBetaHcgDate;
	}



	/**
	 * Set the value related to the column: SECOND_BETA_HCG_DATE
	 * @param secondBetaHcgDate the SECOND_BETA_HCG_DATE value
	 */
			public void setSecondBetaHcgDate (java.util.Date secondBetaHcgDate) {
			this.secondBetaHcgDate = secondBetaHcgDate;
	}



	/**
	 * Return the value associated with the column: SECOND_BETA_HCG_VALUE
	 */

	public double getSecondBetaHcgValue () {
			return secondBetaHcgValue;
	}



	/**
	 * Set the value related to the column: SECOND_BETA_HCG_VALUE
	 * @param secondBetaHcgValue the SECOND_BETA_HCG_VALUE value
	 */
			public void setSecondBetaHcgValue (double secondBetaHcgValue) {
			this.secondBetaHcgValue = secondBetaHcgValue;
	}



	/**
	 * Return the value associated with the column: FIRST_ULTRASOUND_DATE
	 */

	public java.util.Date getFirstUltrasoundDate () {
			return firstUltrasoundDate;
	}



	/**
	 * Set the value related to the column: FIRST_ULTRASOUND_DATE
	 * @param firstUltrasoundDate the FIRST_ULTRASOUND_DATE value
	 */
			public void setFirstUltrasoundDate (java.util.Date firstUltrasoundDate) {
			this.firstUltrasoundDate = firstUltrasoundDate;
	}



	/**
	 * Return the value associated with the column: GESTATIONAL_SACS_COUNT
	 */

	public java.lang.Integer getGestationalSacsCount () {
						return gestationalSacsCount == null ? Integer.valueOf(0) : gestationalSacsCount;
		}



	/**
	 * Set the value related to the column: GESTATIONAL_SACS_COUNT
	 * @param gestationalSacsCount the GESTATIONAL_SACS_COUNT value
	 */
			public void setGestationalSacsCount (java.lang.Integer gestationalSacsCount) {
			this.gestationalSacsCount = gestationalSacsCount;
	}



	/**
	 * Return the value associated with the column: FETAL_HEARTBEATS_COUNT
	 */

	public java.lang.Integer getFetalHeartbeatsCount () {
						return fetalHeartbeatsCount == null ? Integer.valueOf(0) : fetalHeartbeatsCount;
		}



	/**
	 * Set the value related to the column: FETAL_HEARTBEATS_COUNT
	 * @param fetalHeartbeatsCount the FETAL_HEARTBEATS_COUNT value
	 */
			public void setFetalHeartbeatsCount (java.lang.Integer fetalHeartbeatsCount) {
			this.fetalHeartbeatsCount = fetalHeartbeatsCount;
	}



	/**
	 * Return the value associated with the column: OUTCOME
	 */

	public java.lang.String getOutcome () {
			return outcome;
	}



	/**
	 * Set the value related to the column: OUTCOME
	 * @param outcome the OUTCOME value
	 */
			public void setOutcome (java.lang.String outcome) {
			this.outcome = outcome;
	}



	/**
	 * Return the value associated with the column: OUTCOME_DATE
	 */

	public java.util.Date getOutcomeDate () {
			return outcomeDate;
	}



	/**
	 * Set the value related to the column: OUTCOME_DATE
	 * @param outcomeDate the OUTCOME_DATE value
	 */
			public void setOutcomeDate (java.util.Date outcomeDate) {
			this.outcomeDate = outcomeDate;
	}



	/**
	 * Return the value associated with the column: OUTCOME_NOTES
	 */

	public java.lang.String getOutcomeNotes () {
			return outcomeNotes;
	}



	/**
	 * Set the value related to the column: OUTCOME_NOTES
	 * @param outcomeNotes the OUTCOME_NOTES value
	 */
			public void setOutcomeNotes (java.lang.String outcomeNotes) {
			this.outcomeNotes = outcomeNotes;
	}



	/**
	 * Return the value associated with the column: DELIVERY_DATE
	 */

	public java.util.Date getDeliveryDate () {
			return deliveryDate;
	}



	/**
	 * Set the value related to the column: DELIVERY_DATE
	 * @param deliveryDate the DELIVERY_DATE value
	 */
			public void setDeliveryDate (java.util.Date deliveryDate) {
			this.deliveryDate = deliveryDate;
	}



	/**
	 * Return the value associated with the column: DELIVERY_TYPE
	 */

	public java.lang.String getDeliveryType () {
			return deliveryType;
	}



	/**
	 * Set the value related to the column: DELIVERY_TYPE
	 * @param deliveryType the DELIVERY_TYPE value
	 */
			public void setDeliveryType (java.lang.String deliveryType) {
			this.deliveryType = deliveryType;
	}



	/**
	 * Return the value associated with the column: GESTATIONAL_WEEKS
	 */

	public java.lang.Integer getGestationalWeeks () {
						return gestationalWeeks == null ? Integer.valueOf(0) : gestationalWeeks;
		}



	/**
	 * Set the value related to the column: GESTATIONAL_WEEKS
	 * @param gestationalWeeks the GESTATIONAL_WEEKS value
	 */
			public void setGestationalWeeks (java.lang.Integer gestationalWeeks) {
			this.gestationalWeeks = gestationalWeeks;
	}



	/**
	 * Return the value associated with the column: BABIES_COUNT
	 */

	public java.lang.Integer getBabiesCount () {
						return babiesCount == null ? Integer.valueOf(0) : babiesCount;
		}



	/**
	 * Set the value related to the column: BABIES_COUNT
	 * @param babiesCount the BABIES_COUNT value
	 */
			public void setBabiesCount (java.lang.Integer babiesCount) {
			this.babiesCount = babiesCount;
	}



	/**
	 * Return the value associated with the column: DELIVERY_NOTES
	 */

	public java.lang.String getDeliveryNotes () {
			return deliveryNotes;
	}



	/**
	 * Set the value related to the column: DELIVERY_NOTES
	 * @param deliveryNotes the DELIVERY_NOTES value
	 */
			public void setDeliveryNotes (java.lang.String deliveryNotes) {
			this.deliveryNotes = deliveryNotes;
	}



	/**
	 * Return the value associated with the column: embryos
	 */

	public java.util.Set<com.floreantpos.model.Embryo> getEmbryos () {
			return embryos;
	}



	/**
	 * Set the value related to the column: embryos
	 * @param embryos the embryos value
	 */
			public void setEmbryos (java.util.Set<com.floreantpos.model.Embryo> embryos) {
			this.embryos = embryos;
	}

	public void addToembryos (com.floreantpos.model.Embryo embryo) {
		if (null == getEmbryos()) setEmbryos(new java.util.TreeSet<com.floreantpos.model.Embryo>());
		getEmbryos().add(embryo);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.EmbryoTransfer)) return false;
		else {
			com.floreantpos.model.EmbryoTransfer embryoTransfer = (com.floreantpos.model.EmbryoTransfer) obj;
			if (null == this.getId() || null == embryoTransfer.getId()) return this == obj;
			else return (this.getId().equals(embryoTransfer.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}