package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PROTOCOL_PHASE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PROTOCOL_PHASE"
 */

public abstract class BaseProtocolPhase  implements Comparable, Serializable {

	public static String REF = "ProtocolPhase"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_ACTUAL_END_DATE = "actualEndDate"; //$NON-NLS-1$
	public static String PROP_MEDICATIONS_JSON = "medicationsJson"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_PHASE_NAME = "phaseName"; //$NON-NLS-1$
	public static String PROP_ACTUAL_START_DATE = "actualStartDate"; //$NON-NLS-1$
	public static String PROP_ESTIMATED_START_DAY = "estimatedStartDay"; //$NON-NLS-1$
	public static String PROP_CYCLE_PLAN = "cyclePlan"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_ESTIMATED_DURATION_DAYS = "estimatedDurationDays"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_MONITORING_TASKS_JSON = "monitoringTasksJson"; //$NON-NLS-1$


	// constructors
	public BaseProtocolPhase () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseProtocolPhase (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseProtocolPhase (
		java.lang.String id,
		com.floreantpos.model.CyclePlan cyclePlan) {

		this.setId(id);
		this.setCyclePlan(cyclePlan);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String phaseName;
				private java.lang.String description;
				private java.lang.Integer estimatedStartDay;
				private java.lang.Integer estimatedDurationDays;
				private java.lang.Integer sortOrder;
				private java.util.Date actualStartDate;
				private java.util.Date actualEndDate;
				private java.lang.String status;
				private java.lang.String medicationsJson;
				private java.lang.String monitoringTasksJson;
	
	// many to one
	private com.floreantpos.model.CyclePlan cyclePlan;

	// collections
	private java.util.Set<com.floreantpos.model.CycleStageLog> cycleStageLogs;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PHASE_NAME
	 */

	public java.lang.String getPhaseName () {
			return phaseName;
	}



	/**
	 * Set the value related to the column: PHASE_NAME
	 * @param phaseName the PHASE_NAME value
	 */
			public void setPhaseName (java.lang.String phaseName) {
			this.phaseName = phaseName;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: ESTIMATED_START_DAY
	 */

	public java.lang.Integer getEstimatedStartDay () {
						return estimatedStartDay == null ? Integer.valueOf(0) : estimatedStartDay;
		}



	/**
	 * Set the value related to the column: ESTIMATED_START_DAY
	 * @param estimatedStartDay the ESTIMATED_START_DAY value
	 */
			public void setEstimatedStartDay (java.lang.Integer estimatedStartDay) {
			this.estimatedStartDay = estimatedStartDay;
	}



	/**
	 * Return the value associated with the column: ESTIMATED_DURATION_DAYS
	 */

	public java.lang.Integer getEstimatedDurationDays () {
						return estimatedDurationDays == null ? Integer.valueOf(0) : estimatedDurationDays;
		}



	/**
	 * Set the value related to the column: ESTIMATED_DURATION_DAYS
	 * @param estimatedDurationDays the ESTIMATED_DURATION_DAYS value
	 */
			public void setEstimatedDurationDays (java.lang.Integer estimatedDurationDays) {
			this.estimatedDurationDays = estimatedDurationDays;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: ACTUAL_START_DATE
	 */

	public java.util.Date getActualStartDate () {
			return actualStartDate;
	}



	/**
	 * Set the value related to the column: ACTUAL_START_DATE
	 * @param actualStartDate the ACTUAL_START_DATE value
	 */
			public void setActualStartDate (java.util.Date actualStartDate) {
			this.actualStartDate = actualStartDate;
	}



	/**
	 * Return the value associated with the column: ACTUAL_END_DATE
	 */

	public java.util.Date getActualEndDate () {
			return actualEndDate;
	}



	/**
	 * Set the value related to the column: ACTUAL_END_DATE
	 * @param actualEndDate the ACTUAL_END_DATE value
	 */
			public void setActualEndDate (java.util.Date actualEndDate) {
			this.actualEndDate = actualEndDate;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: MEDICATIONS_JSON
	 */

	public java.lang.String getMedicationsJson () {
			return medicationsJson;
	}



	/**
	 * Set the value related to the column: MEDICATIONS_JSON
	 * @param medicationsJson the MEDICATIONS_JSON value
	 */
			public void setMedicationsJson (java.lang.String medicationsJson) {
			this.medicationsJson = medicationsJson;
	}



	/**
	 * Return the value associated with the column: MONITORING_TASKS_JSON
	 */

	public java.lang.String getMonitoringTasksJson () {
			return monitoringTasksJson;
	}



	/**
	 * Set the value related to the column: MONITORING_TASKS_JSON
	 * @param monitoringTasksJson the MONITORING_TASKS_JSON value
	 */
			public void setMonitoringTasksJson (java.lang.String monitoringTasksJson) {
			this.monitoringTasksJson = monitoringTasksJson;
	}



	/**
	 * Return the value associated with the column: CYCLE_PLAN_ID
	 */

	public com.floreantpos.model.CyclePlan getCyclePlan () {
			return cyclePlan;
	}



	/**
	 * Set the value related to the column: CYCLE_PLAN_ID
	 * @param cyclePlan the CYCLE_PLAN_ID value
	 */
			public void setCyclePlan (com.floreantpos.model.CyclePlan cyclePlan) {
			this.cyclePlan = cyclePlan;
	}



	/**
	 * Return the value associated with the column: cycleStageLogs
	 */

	public java.util.Set<com.floreantpos.model.CycleStageLog> getCycleStageLogs () {
			return cycleStageLogs;
	}



	/**
	 * Set the value related to the column: cycleStageLogs
	 * @param cycleStageLogs the cycleStageLogs value
	 */
			public void setCycleStageLogs (java.util.Set<com.floreantpos.model.CycleStageLog> cycleStageLogs) {
			this.cycleStageLogs = cycleStageLogs;
	}

	public void addTocycleStageLogs (com.floreantpos.model.CycleStageLog cycleStageLog) {
		if (null == getCycleStageLogs()) setCycleStageLogs(new java.util.TreeSet<com.floreantpos.model.CycleStageLog>());
		getCycleStageLogs().add(cycleStageLog);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ProtocolPhase)) return false;
		else {
			com.floreantpos.model.ProtocolPhase protocolPhase = (com.floreantpos.model.ProtocolPhase) obj;
			if (null == this.getId() || null == protocolPhase.getId()) return this == obj;
			else return (this.getId().equals(protocolPhase.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}