package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PROTOCOL_TEMPLATE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PROTOCOL_TEMPLATE"
 */

public abstract class BaseProtocolTemplate  implements Comparable, Serializable {

	public static String REF = "ProtocolTemplate"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_PROTOCOL_PHASE_TEMPLATE_JSON = "ProtocolPhaseTemplateJson"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DEFAULT_FRESH_TRANSFER = "defaultFreshTransfer"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_ACTIVE = "active"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_TARGET_PATIENT_PROFILE = "targetPatientProfile"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseProtocolTemplate () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseProtocolTemplate (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date createdDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.String targetPatientProfile;
				private java.lang.String protocolPhaseTemplateJson;
				private java.lang.Boolean defaultFreshTransfer;
				private java.lang.Boolean active;
				private java.lang.String performerId;
				private java.lang.String performerName;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: TARGET_PROFILE
	 */

	public java.lang.String getTargetPatientProfile () {
			return targetPatientProfile;
	}



	/**
	 * Set the value related to the column: TARGET_PROFILE
	 * @param targetPatientProfile the TARGET_PROFILE value
	 */
			public void setTargetPatientProfile (java.lang.String targetPatientProfile) {
			this.targetPatientProfile = targetPatientProfile;
	}



	/**
	 * Return the value associated with the column: PROTOCOL_PHASE_TEMPLATE_JSON
	 */

	public java.lang.String getProtocolPhaseTemplateJson () {
			return protocolPhaseTemplateJson;
	}



	/**
	 * Set the value related to the column: PROTOCOL_PHASE_TEMPLATE_JSON
	 * @param protocolPhaseTemplateJson the PROTOCOL_PHASE_TEMPLATE_JSON value
	 */
			public void setProtocolPhaseTemplateJson (java.lang.String protocolPhaseTemplateJson) {
			this.protocolPhaseTemplateJson = protocolPhaseTemplateJson;
	}



	/**
	 * Return the value associated with the column: IS_DEFAULT_FRESH_TRANSFER
	 */

	public java.lang.Boolean isDefaultFreshTransfer () {
						return defaultFreshTransfer == null ? Boolean.valueOf(true) : defaultFreshTransfer;
			}

	public java.lang.Boolean getDefaultFreshTransfer () {
					return defaultFreshTransfer == null ? Boolean.valueOf(true) : defaultFreshTransfer;
			}


	/**
	 * Set the value related to the column: IS_DEFAULT_FRESH_TRANSFER
	 * @param defaultFreshTransfer the IS_DEFAULT_FRESH_TRANSFER value
	 */
			public void setDefaultFreshTransfer (java.lang.Boolean defaultFreshTransfer) {
			this.defaultFreshTransfer = defaultFreshTransfer;
	}


	/**
	 * Custom property
	 */
	public static String getDefaultFreshTransferDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: IS_ACTIVE
	 */

	public java.lang.Boolean isActive () {
						return active == null ? Boolean.valueOf(true) : active;
			}

	public java.lang.Boolean getActive () {
					return active == null ? Boolean.valueOf(true) : active;
			}


	/**
	 * Set the value related to the column: IS_ACTIVE
	 * @param active the IS_ACTIVE value
	 */
			public void setActive (java.lang.Boolean active) {
			this.active = active;
	}


	/**
	 * Custom property
	 */
	public static String getActiveDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */

	public java.lang.String getPerformerId () {
			return performerId;
	}



	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
			public void setPerformerId (java.lang.String performerId) {
			this.performerId = performerId;
	}



	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */

	public java.lang.String getPerformerName () {
			return performerName;
	}



	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
			public void setPerformerName (java.lang.String performerName) {
			this.performerName = performerName;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ProtocolTemplate)) return false;
		else {
			com.floreantpos.model.ProtocolTemplate protocolTemplate = (com.floreantpos.model.ProtocolTemplate) obj;
			if (null == this.getId() || null == protocolTemplate.getId()) return this == obj;
			else return (this.getId().equals(protocolTemplate.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}