package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the SPERM_SAMPLE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="SPERM_SAMPLE"
 */

public abstract class BaseSpermSample  implements Comparable, Serializable {

	public static String REF = "SpermSample"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_COLLECTION_DATE = "collectionDate"; //$NON-NLS-1$
	public static String PROP_COLLECTION_METHOD = "collectionMethod"; //$NON-NLS-1$
	public static String PROP_SPERM_SOURCE = "spermSource"; //$NON-NLS-1$
	public static String PROP_DONOR_ID = "donorId"; //$NON-NLS-1$
	public static String PROP_MALE_PARTNER_ID = "malePartnerId"; //$NON-NLS-1$
	public static String PROP_VOLUME = "volume"; //$NON-NLS-1$
	public static String PROP_CONCENTRATION = "concentration"; //$NON-NLS-1$
	public static String PROP_TOTAL_COUNT = "totalCount"; //$NON-NLS-1$
	public static String PROP_MOTILITY = "motility"; //$NON-NLS-1$
	public static String PROP_PROGRESSIVE_MOTILITY = "progressiveMotility"; //$NON-NLS-1$
	public static String PROP_MORPHOLOGY = "morphology"; //$NON-NLS-1$
	public static String PROP_PH = "ph"; //$NON-NLS-1$
	public static String PROP_PROCESSING_METHOD = "processingMethod"; //$NON-NLS-1$
	public static String PROP_PROCESSING_DATE = "processingDate"; //$NON-NLS-1$
	public static String PROP_PROCESSING_TECHNICIAN_ID = "processingTechnicianId"; //$NON-NLS-1$
	public static String PROP_PROCESSING_TECHNICIAN_NAME = "processingTechnicianName"; //$NON-NLS-1$
	public static String PROP_POST_PROCESSING_VOLUME = "postProcessingVolume"; //$NON-NLS-1$
	public static String PROP_POST_PROCESSING_CONCENTRATION = "postProcessingConcentration"; //$NON-NLS-1$
	public static String PROP_POST_PROCESSING_TOTAL_COUNT = "postProcessingTotalCount"; //$NON-NLS-1$
	public static String PROP_POST_PROCESSING_MOTILITY = "postProcessingMotility"; //$NON-NLS-1$
	public static String PROP_POST_PROCESSING_PROGRESSIVE_MOTILITY = "postProcessingProgressiveMotility"; //$NON-NLS-1$
	public static String PROP_FERTILIZATION_METHOD = "fertilizationMethod"; //$NON-NLS-1$
	public static String PROP_USED = "used"; //$NON-NLS-1$
	public static String PROP_USED_DATE = "usedDate"; //$NON-NLS-1$
	public static String PROP_USED_IN_CYCLE_PLAN_ID = "usedInCyclePlanId"; //$NON-NLS-1$
	public static String PROP_FROZEN = "frozen"; //$NON-NLS-1$
	public static String PROP_FREEZE_DATE = "freezeDate"; //$NON-NLS-1$
	public static String PROP_STORAGE_LOCATION = "storageLocation"; //$NON-NLS-1$
	public static String PROP_TANK_NUMBER = "tankNumber"; //$NON-NLS-1$
	public static String PROP_CANE_NUMBER = "caneNumber"; //$NON-NLS-1$
	public static String PROP_STORAGE_CONTAINER_ID = "storageContainerId"; //$NON-NLS-1$
	public static String PROP_THAW_DATE = "thawDate"; //$NON-NLS-1$
	public static String PROP_NOTES = "notes"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseSpermSample () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseSpermSample (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
	private java.lang.String outletId;
	private java.util.Date createdDate;
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.String properties;
	private java.lang.Boolean deleted;
	private java.util.Date collectionDate;
	private java.lang.String collectionMethod;
	private java.lang.String spermSource;
	private java.lang.String donorId;
	private java.lang.String malePartnerId;
	private java.lang.Double volume;
	private java.lang.Double concentration;
	private java.lang.Double totalCount;
	private java.lang.Double motility;
	private java.lang.Double progressiveMotility;
	private java.lang.Double morphology;
	private java.lang.Double ph;
	private java.lang.String processingMethod;
	private java.util.Date processingDate;
	private java.lang.String processingTechnicianId;
	private java.lang.String processingTechnicianName;
	private java.lang.Double postProcessingVolume;
	private java.lang.Double postProcessingConcentration;
	private java.lang.Double postProcessingTotalCount;
	private java.lang.Double postProcessingMotility;
	private java.lang.Double postProcessingProgressiveMotility;
	private java.lang.String fertilizationMethod;
	private java.lang.Boolean used;
	private java.util.Date usedDate;
	private java.lang.String usedInCyclePlanId;
	private java.lang.Boolean frozen;
	private java.util.Date freezeDate;
	private java.lang.String storageLocation;
	private java.lang.String tankNumber;
	private java.lang.String caneNumber;
	private java.lang.String storageContainerId;
	private java.util.Date thawDate;
	private java.lang.String notes;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	public java.lang.String getOutletId () {
		return outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
	}

	/**
	 * Return the value associated with the column: CREATED_DATE
	 */
	public java.util.Date getCreatedDate () {
		return createdDate;
	}

	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
	public void setCreatedDate (java.util.Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime () {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime (java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime () {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime (java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties () {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties (java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean isDeleted () {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted () {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted (java.lang.Boolean deleted) {
		this.deleted = deleted;
	}

	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}

	/**
	 * Return the value associated with the column: COLLECTION_DATE
	 */
	public java.util.Date getCollectionDate () {
		return collectionDate;
	}

	/**
	 * Set the value related to the column: COLLECTION_DATE
	 * @param collectionDate the COLLECTION_DATE value
	 */
	public void setCollectionDate (java.util.Date collectionDate) {
		this.collectionDate = collectionDate;
	}

	/**
	 * Return the value associated with the column: COLLECTION_METHOD
	 */
	public java.lang.String getCollectionMethod () {
		return collectionMethod;
	}

	/**
	 * Set the value related to the column: COLLECTION_METHOD
	 * @param collectionMethod the COLLECTION_METHOD value
	 */
	public void setCollectionMethod (java.lang.String collectionMethod) {
		this.collectionMethod = collectionMethod;
	}

	/**
	 * Return the value associated with the column: SPERM_SOURCE
	 */
	public java.lang.String getSpermSource () {
		return spermSource;
	}

	/**
	 * Set the value related to the column: SPERM_SOURCE
	 * @param spermSource the SPERM_SOURCE value
	 */
	public void setSpermSource (java.lang.String spermSource) {
		this.spermSource = spermSource;
	}

	/**
	 * Return the value associated with the column: DONOR_ID
	 */
	public java.lang.String getDonorId () {
		return donorId;
	}

	/**
	 * Set the value related to the column: DONOR_ID
	 * @param donorId the DONOR_ID value
	 */
	public void setDonorId (java.lang.String donorId) {
		this.donorId = donorId;
	}

	/**
	 * Return the value associated with the column: MALE_PARTNER_ID
	 */
	public java.lang.String getMalePartnerId () {
		return malePartnerId;
	}

	/**
	 * Set the value related to the column: MALE_PARTNER_ID
	 * @param malePartnerId the MALE_PARTNER_ID value
	 */
	public void setMalePartnerId (java.lang.String malePartnerId) {
		this.malePartnerId = malePartnerId;
	}

	/**
	 * Return the value associated with the column: VOLUME
	 */
	public java.lang.Double getVolume () {
		return volume == null ? Double.valueOf(0) : volume;
	}

	/**
	 * Set the value related to the column: VOLUME
	 * @param volume the VOLUME value
	 */
	public void setVolume (java.lang.Double volume) {
		this.volume = volume;
	}

	/**
	 * Return the value associated with the column: CONCENTRATION
	 */
	public java.lang.Double getConcentration () {
		return concentration == null ? Double.valueOf(0) : concentration;
	}

	/**
	 * Set the value related to the column: CONCENTRATION
	 * @param concentration the CONCENTRATION value
	 */
	public void setConcentration (java.lang.Double concentration) {
		this.concentration = concentration;
	}

	/**
	 * Return the value associated with the column: TOTAL_COUNT
	 */
	public java.lang.Double getTotalCount () {
		return totalCount == null ? Double.valueOf(0) : totalCount;
	}

	/**
	 * Set the value related to the column: TOTAL_COUNT
	 * @param totalCount the TOTAL_COUNT value
	 */
	public void setTotalCount (java.lang.Double totalCount) {
		this.totalCount = totalCount;
	}

	/**
	 * Return the value associated with the column: MOTILITY
	 */
	public java.lang.Double getMotility () {
		return motility == null ? Double.valueOf(0) : motility;
	}

	/**
	 * Set the value related to the column: MOTILITY
	 * @param motility the MOTILITY value
	 */
	public void setMotility (java.lang.Double motility) {
		this.motility = motility;
	}

	/**
	 * Return the value associated with the column: PROGRESSIVE_MOTILITY
	 */
	public java.lang.Double getProgressiveMotility () {
		return progressiveMotility == null ? Double.valueOf(0) : progressiveMotility;
	}

	/**
	 * Set the value related to the column: PROGRESSIVE_MOTILITY
	 * @param progressiveMotility the PROGRESSIVE_MOTILITY value
	 */
	public void setProgressiveMotility (java.lang.Double progressiveMotility) {
		this.progressiveMotility = progressiveMotility;
	}

	/**
	 * Return the value associated with the column: MORPHOLOGY
	 */
	public java.lang.Double getMorphology () {
		return morphology == null ? Double.valueOf(0) : morphology;
	}

	/**
	 * Set the value related to the column: MORPHOLOGY
	 * @param morphology the MORPHOLOGY value
	 */
	public void setMorphology (java.lang.Double morphology) {
		this.morphology = morphology;
	}

	/**
	 * Return the value associated with the column: PH
	 */
	public java.lang.Double getPh () {
		return ph == null ? Double.valueOf(0) : ph;
	}

	/**
	 * Set the value related to the column: PH
	 * @param ph the PH value
	 */
	public void setPh (java.lang.Double ph) {
		this.ph = ph;
	}

	/**
	 * Return the value associated with the column: PROCESSING_METHOD
	 */
	public java.lang.String getProcessingMethod () {
		return processingMethod;
	}

	/**
	 * Set the value related to the column: PROCESSING_METHOD
	 * @param processingMethod the PROCESSING_METHOD value
	 */
	public void setProcessingMethod (java.lang.String processingMethod) {
		this.processingMethod = processingMethod;
	}

	/**
	 * Return the value associated with the column: PROCESSING_DATE
	 */
	public java.util.Date getProcessingDate () {
		return processingDate;
	}

	/**
	 * Set the value related to the column: PROCESSING_DATE
	 * @param processingDate the PROCESSING_DATE value
	 */
	public void setProcessingDate (java.util.Date processingDate) {
		this.processingDate = processingDate;
	}

	/**
	 * Return the value associated with the column: PROCESSING_TECHNICIAN_ID
	 */
	public java.lang.String getProcessingTechnicianId () {
		return processingTechnicianId;
	}

	/**
	 * Set the value related to the column: PROCESSING_TECHNICIAN_ID
	 * @param processingTechnicianId the PROCESSING_TECHNICIAN_ID value
	 */
	public void setProcessingTechnicianId (java.lang.String processingTechnicianId) {
		this.processingTechnicianId = processingTechnicianId;
	}

	/**
	 * Return the value associated with the column: PROCESSING_TECHNICIAN_NAME
	 */
	public java.lang.String getProcessingTechnicianName () {
		return processingTechnicianName;
	}

	/**
	 * Set the value related to the column: PROCESSING_TECHNICIAN_NAME
	 * @param processingTechnicianName the PROCESSING_TECHNICIAN_NAME value
	 */
	public void setProcessingTechnicianName (java.lang.String processingTechnicianName) {
		this.processingTechnicianName = processingTechnicianName;
	}

	/**
	 * Return the value associated with the column: POST_PROCESSING_VOLUME
	 */
	public java.lang.Double getPostProcessingVolume () {
		return postProcessingVolume == null ? Double.valueOf(0) : postProcessingVolume;
	}

	/**
	 * Set the value related to the column: POST_PROCESSING_VOLUME
	 * @param postProcessingVolume the POST_PROCESSING_VOLUME value
	 */
	public void setPostProcessingVolume (java.lang.Double postProcessingVolume) {
		this.postProcessingVolume = postProcessingVolume;
	}

	/**
	 * Return the value associated with the column: POST_PROCESSING_CONCENTRATION
	 */
	public java.lang.Double getPostProcessingConcentration () {
		return postProcessingConcentration == null ? Double.valueOf(0) : postProcessingConcentration;
	}

	/**
	 * Set the value related to the column: POST_PROCESSING_CONCENTRATION
	 * @param postProcessingConcentration the POST_PROCESSING_CONCENTRATION value
	 */
	public void setPostProcessingConcentration (java.lang.Double postProcessingConcentration) {
		this.postProcessingConcentration = postProcessingConcentration;
	}

	/**
	 * Return the value associated with the column: POST_PROCESSING_TOTAL_COUNT
	 */
	public java.lang.Double getPostProcessingTotalCount () {
		return postProcessingTotalCount == null ? Double.valueOf(0) : postProcessingTotalCount;
	}

	/**
	 * Set the value related to the column: POST_PROCESSING_TOTAL_COUNT
	 * @param postProcessingTotalCount the POST_PROCESSING_TOTAL_COUNT value
	 */
	public void setPostProcessingTotalCount (java.lang.Double postProcessingTotalCount) {
		this.postProcessingTotalCount = postProcessingTotalCount;
	}

	/**
	 * Return the value associated with the column: POST_PROCESSING_MOTILITY
	 */
	public java.lang.Double getPostProcessingMotility () {
		return postProcessingMotility == null ? Double.valueOf(0) : postProcessingMotility;
	}

	/**
	 * Set the value related to the column: POST_PROCESSING_MOTILITY
	 * @param postProcessingMotility the POST_PROCESSING_MOTILITY value
	 */
	public void setPostProcessingMotility (java.lang.Double postProcessingMotility) {
		this.postProcessingMotility = postProcessingMotility;
	}

	/**
	 * Return the value associated with the column: POST_PROCESSING_PROGRESSIVE_MOTILITY
	 */
	public java.lang.Double getPostProcessingProgressiveMotility () {
		return postProcessingProgressiveMotility == null ? Double.valueOf(0) : postProcessingProgressiveMotility;
	}

	/**
	 * Set the value related to the column: POST_PROCESSING_PROGRESSIVE_MOTILITY
	 * @param postProcessingProgressiveMotility the POST_PROCESSING_PROGRESSIVE_MOTILITY value
	 */
	public void setPostProcessingProgressiveMotility (java.lang.Double postProcessingProgressiveMotility) {
		this.postProcessingProgressiveMotility = postProcessingProgressiveMotility;
	}

	/**
	 * Return the value associated with the column: FERTILIZATION_METHOD
	 */
	public java.lang.String getFertilizationMethod () {
		return fertilizationMethod;
	}

	/**
	 * Set the value related to the column: FERTILIZATION_METHOD
	 * @param fertilizationMethod the FERTILIZATION_METHOD value
	 */
	public void setFertilizationMethod (java.lang.String fertilizationMethod) {
		this.fertilizationMethod = fertilizationMethod;
	}

	/**
	 * Return the value associated with the column: USED
	 */
	public java.lang.Boolean isUsed () {
		return used == null ? Boolean.FALSE : used;
	}

	public java.lang.Boolean getUsed () {
		return used == null ? Boolean.FALSE : used;
	}

	/**
	 * Set the value related to the column: USED
	 * @param used the USED value
	 */
	public void setUsed (java.lang.Boolean used) {
		this.used = used;
	}

	/**
	 * Return the value associated with the column: USED_DATE
	 */
	public java.util.Date getUsedDate () {
		return usedDate;
	}

	/**
	 * Set the value related to the column: USED_DATE
	 * @param usedDate the USED_DATE value
	 */
	public void setUsedDate (java.util.Date usedDate) {
		this.usedDate = usedDate;
	}

	/**
	 * Return the value associated with the column: USED_IN_CYCLE_PLAN_ID
	 */
	public java.lang.String getUsedInCyclePlanId () {
		return usedInCyclePlanId;
	}

	/**
	 * Set the value related to the column: USED_IN_CYCLE_PLAN_ID
	 * @param usedInCyclePlanId the USED_IN_CYCLE_PLAN_ID value
	 */
	public void setUsedInCyclePlanId (java.lang.String usedInCyclePlanId) {
		this.usedInCyclePlanId = usedInCyclePlanId;
	}

	/**
	 * Return the value associated with the column: FROZEN
	 */
	public java.lang.Boolean isFrozen () {
		return frozen == null ? Boolean.FALSE : frozen;
	}

	public java.lang.Boolean getFrozen () {
		return frozen == null ? Boolean.FALSE : frozen;
	}

	/**
	 * Set the value related to the column: FROZEN
	 * @param frozen the FROZEN value
	 */
	public void setFrozen (java.lang.Boolean frozen) {
		this.frozen = frozen;
	}

	/**
	 * Return the value associated with the column: FREEZE_DATE
	 */
	public java.util.Date getFreezeDate () {
		return freezeDate;
	}

	/**
	 * Set the value related to the column: FREEZE_DATE
	 * @param freezeDate the FREEZE_DATE value
	 */
	public void setFreezeDate (java.util.Date freezeDate) {
		this.freezeDate = freezeDate;
	}

	/**
	 * Return the value associated with the column: STORAGE_LOCATION
	 */
	public java.lang.String getStorageLocation () {
		return storageLocation;
	}

	/**
	 * Set the value related to the column: STORAGE_LOCATION
	 * @param storageLocation the STORAGE_LOCATION value
	 */
	public void setStorageLocation (java.lang.String storageLocation) {
		this.storageLocation = storageLocation;
	}

	/**
	 * Return the value associated with the column: TANK_NUMBER
	 */
	public java.lang.String getTankNumber () {
		return tankNumber;
	}

	/**
	 * Set the value related to the column: TANK_NUMBER
	 * @param tankNumber the TANK_NUMBER value
	 */
	public void setTankNumber (java.lang.String tankNumber) {
		this.tankNumber = tankNumber;
	}

	/**
	 * Return the value associated with the column: CANE_NUMBER
	 */
	public java.lang.String getCaneNumber () {
		return caneNumber;
	}

	/**
	 * Set the value related to the column: CANE_NUMBER
	 * @param caneNumber the CANE_NUMBER value
	 */
	public void setCaneNumber (java.lang.String caneNumber) {
		this.caneNumber = caneNumber;
	}

	/**
	 * Return the value associated with the column: THAW_DATE
	 */
	public java.util.Date getThawDate () {
		return thawDate;
	}

	/**
	 * Set the value related to the column: THAW_DATE
	 * @param thawDate the THAW_DATE value
	 */
	public void setThawDate (java.util.Date thawDate) {
		this.thawDate = thawDate;
	}

	/**
	 * Return the value associated with the column: NOTES
	 */
	public java.lang.String getNotes () {
		return notes;
	}

	/**
	 * Set the value related to the column: NOTES
	 * @param notes the NOTES value
	 */
	public void setNotes (java.lang.String notes) {
		this.notes = notes;
	}



	/**
	 * Return the value associated with the column: STORAGE_CONTAINER_ID
	 */

	public java.lang.String getStorageContainerId () {
		return storageContainerId;
	}



	/**
	 * Set the value related to the column: STORAGE_CONTAINER_ID
	 * @param storageContainerId the STORAGE_CONTAINER_ID value
	 */
	public void setStorageContainerId (java.lang.String storageContainerId) {
		this.storageContainerId = storageContainerId;
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.SpermSample)) return false;
		else {
			com.floreantpos.model.SpermSample spermSample = (com.floreantpos.model.SpermSample) obj;
			if (null == this.getId() || null == spermSample.getId()) return this == obj;
			else return (this.getId().equals(spermSample.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}
