package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Represents an actual medication instance in a CyclePlan phase,
 * deep-copied from ProtocolMedication with tracking capabilities.
 *
 * This is a non-persistent POJO stored as JSON within ProtocolPhase.
 */
public class CycleMedication implements Serializable {
	private static final long serialVersionUID = 1L;

	// Template fields (copied from ProtocolMedication)
	private String medicationName;
	private String dosage;
	private String frequency;
	private String instructions;

	// Runtime tracking fields
	private Boolean completed;
	private Date actualStartDate;
	private Date actualEndDate;
	private List<AdministrationRecord> administrationLog = new ArrayList<>();

	public CycleMedication() {
		this.completed = false;
	}

	/**
	 * Factory method to create a CycleMedication from a ProtocolMedication (deep copy)
	 */
	public static CycleMedication fromTemplate(ProtocolMedication template) {
		if (template == null) {
			return null;
		}

		CycleMedication medication = new CycleMedication();
		medication.setMedicationName(template.getMedicationName());
		medication.setDosage(template.getDosage());
		medication.setFrequency(template.getFrequency());
		medication.setInstructions(template.getInstructions());

		return medication;
	}

	// Inner class for administration log entries
	public static class AdministrationRecord implements Serializable {
		private static final long serialVersionUID = 1L;

		private Date administeredDate;
		private String administeredBy;
		private String notes;

		public AdministrationRecord() {
		}

		public AdministrationRecord(Date administeredDate, String administeredBy, String notes) {
			this.administeredDate = administeredDate;
			this.administeredBy = administeredBy;
			this.notes = notes;
		}

		public Date getAdministeredDate() {
			return administeredDate;
		}

		public void setAdministeredDate(Date administeredDate) {
			this.administeredDate = administeredDate;
		}

		public String getAdministeredBy() {
			return administeredBy;
		}

		public void setAdministeredBy(String administeredBy) {
			this.administeredBy = administeredBy;
		}

		public String getNotes() {
			return notes;
		}

		public void setNotes(String notes) {
			this.notes = notes;
		}
	}

	// Getters and Setters

	public String getMedicationName() {
		return medicationName;
	}

	public void setMedicationName(String medicationName) {
		this.medicationName = medicationName;
	}

	public String getDosage() {
		return dosage;
	}

	public void setDosage(String dosage) {
		this.dosage = dosage;
	}

	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	public String getInstructions() {
		return instructions;
	}

	public void setInstructions(String instructions) {
		this.instructions = instructions;
	}

	public Boolean getCompleted() {
		return completed;
	}

	public void setCompleted(Boolean completed) {
		this.completed = completed;
	}

	public Date getActualStartDate() {
		return actualStartDate;
	}

	public void setActualStartDate(Date actualStartDate) {
		this.actualStartDate = actualStartDate;
	}

	public Date getActualEndDate() {
		return actualEndDate;
	}

	public void setActualEndDate(Date actualEndDate) {
		this.actualEndDate = actualEndDate;
	}

	public List<AdministrationRecord> getAdministrationLog() {
		return administrationLog;
	}

	public void setAdministrationLog(List<AdministrationRecord> administrationLog) {
		this.administrationLog = administrationLog;
	}
}
