package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.Date;

/**
 * Represents an actual monitoring task instance in a CyclePlan phase,
 * deep-copied from ProtocolMonitoringTask with tracking capabilities.
 *
 * This is a non-persistent POJO stored as JSON within ProtocolPhase.
 */
public class CycleMonitoringTask implements Serializable {
	private static final long serialVersionUID = 1L;

	// Template fields (copied from ProtocolMonitoringTask)
	private String taskName;
	private String schedule;
	private String details;

	// Runtime tracking fields
	private Boolean completed;
	private Date completedDate;
	private String results;
	private String performedBy;
	private String notes;

	public CycleMonitoringTask() {
		this.completed = false;
	}

	/**
	 * Factory method to create a CycleMonitoringTask from a ProtocolMonitoringTask (deep copy)
	 */
	public static CycleMonitoringTask fromTemplate(ProtocolMonitoringTask template) {
		if (template == null) {
			return null;
		}

		CycleMonitoringTask task = new CycleMonitoringTask();
		task.setTaskName(template.getTaskName());
		task.setSchedule(template.getSchedule());
		task.setDetails(template.getDetails());

		return task;
	}

	// Getters and Setters

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getSchedule() {
		return schedule;
	}

	public void setSchedule(String schedule) {
		this.schedule = schedule;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	public Boolean getCompleted() {
		return completed;
	}

	public void setCompleted(Boolean completed) {
		this.completed = completed;
	}

	public Date getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}

	public String getResults() {
		return results;
	}

	public void setResults(String results) {
		this.results = results;
	}

	public String getPerformedBy() {
		return performedBy;
	}

	public void setPerformedBy(String performedBy) {
		this.performedBy = performedBy;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}
}
