package com.floreantpos.model.consultation;

/**
 * Enum representing the status of a CyclePlan in the IVF process.
 * Tracks the progression from planning through embryo creation.
 */
public enum CycleStatus {
	//@formatter:off
	PLANNED("Planned", "Cycle plan has been created and is ready to begin"),
	IN_PROGRESS("In Progress", "Actively undergoing stimulation and monitoring"),
	STIMULATION("Stimulation", "Patient is receiving ovarian stimulation medications"),
	MONITORING("Monitoring", "Monitoring follicle development and hormone levels"),
	RETRIEVAL_SCHEDULED("Retrieval Scheduled", "Ready for egg retrieval procedure"),
	RETRIEVAL_COMPLETED("Retrieval Completed", "Eggs have been retrieved successfully"),
	EMBRYOS_READY("Embryos Ready", "Embryos created and available for transfer"),
	ALL_EMBRYOS_USED("All Embryos Used", "All embryos have been transferred or are no longer viable"),
	COMPLETED("Completed", "Cycle successfully completed with embryos available"),
	FAILED_NO_EMBRYOS("Failed - No Embryos", "Cycle failed: no embryos were created"),
	FAILED_NO_EGGS("Failed - No Eggs", "Cycle failed: no eggs were retrieved"),
	CANCELLED("Cancelled", "Cycle was stopped or cancelled");

	//@formatter:on
	private final String displayName;
	private final String description;

	CycleStatus(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
