package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.Date;

/**
 * Represents female initial fertility workup data including hormone levels and ultrasound findings.
 * This is a non-persistent POJO stored as JSON within Couple entity.
 */
public class FemaleInitialWorkup implements Serializable {
	private static final long serialVersionUID = 1L;

	// Primary Ovarian Reserve Markers
	private Double amhLevel; // Anti-Müllerian Hormone (ng/mL) - Normal: 1.0-4.0
	private Double fsh; // Follicle Stimulating Hormone (mIU/mL) - Day 2-3 of cycle
	private Integer antralFollicleCount; // AFC - Total count both ovaries

	// Other Hormone Levels
	private Double lh; // Luteinizing Hormone (mIU/mL)
	private Double estradiol; // E2 - Estradiol (pg/mL) - Day 2-3 of cycle
	private Double progesterone; // Progesterone (ng/mL)
	private Double tsh; // Thyroid Stimulating Hormone (μIU/mL)
	private Double prolactin; // Prolactin (ng/mL)
	private Double testosteroneTotal; // Total Testosterone (ng/dL)
	private Double testosteroneFree; // Free Testosterone (pg/mL)
	private Double dheas; // DHEA-Sulfate (μg/dL)

	// Ultrasound Findings
	private String uterineSize; // e.g., "Normal" or dimensions
	private String endometrialThickness; // e.g., "8mm"
	private String ovaryRightSize; // Right ovary dimensions
	private String ovaryLeftSize; // Left ovary dimensions
	private Integer afcRight; // AFC in right ovary
	private Integer afcLeft; // AFC in left ovary
	private String fibroids; // Presence and description
	private String cysts; // Presence and description
	private String polyps; // Presence and description

	// Additional Tests
	private String hsgResult; // Hysterosalpingography result
	private String tubalPatency; // Both tubes, Right only, Left only, Both blocked
	private String bloodType; // e.g., "O+", "A-"
	private String rubella; // Immune, Non-immune
	private String hiv; // Negative, Positive
	private String hepatitisB; // Negative, Positive
	private String hepatitisC; // Negative, Positive
	private String syphilis; // Negative, Positive

	// Test metadata
	private Date testDate;
	private String performedBy; // Clinic or doctor name
	private String labName; // Laboratory name

	// Other test results and clinical notes
	private String otherTestResults;
	private String note;

	public FemaleInitialWorkup() {
	}

	// Getters and Setters

	public Double getAmhLevel() {
		return amhLevel;
	}

	public void setAmhLevel(Double amhLevel) {
		this.amhLevel = amhLevel;
	}

	public Double getFsh() {
		return fsh;
	}

	public void setFsh(Double fsh) {
		this.fsh = fsh;
	}

	public Integer getAntralFollicleCount() {
		return antralFollicleCount;
	}

	public void setAntralFollicleCount(Integer antralFollicleCount) {
		this.antralFollicleCount = antralFollicleCount;
	}

	public Double getLh() {
		return lh;
	}

	public void setLh(Double lh) {
		this.lh = lh;
	}

	public Double getEstradiol() {
		return estradiol;
	}

	public void setEstradiol(Double estradiol) {
		this.estradiol = estradiol;
	}

	public Double getProgesterone() {
		return progesterone;
	}

	public void setProgesterone(Double progesterone) {
		this.progesterone = progesterone;
	}

	public Double getTsh() {
		return tsh;
	}

	public void setTsh(Double tsh) {
		this.tsh = tsh;
	}

	public Double getProlactin() {
		return prolactin;
	}

	public void setProlactin(Double prolactin) {
		this.prolactin = prolactin;
	}

	public Double getTestosteroneTotal() {
		return testosteroneTotal;
	}

	public void setTestosteroneTotal(Double testosteroneTotal) {
		this.testosteroneTotal = testosteroneTotal;
	}

	public Double getTestosteroneFree() {
		return testosteroneFree;
	}

	public void setTestosteroneFree(Double testosteroneFree) {
		this.testosteroneFree = testosteroneFree;
	}

	public Double getDheas() {
		return dheas;
	}

	public void setDheas(Double dheas) {
		this.dheas = dheas;
	}

	public String getUterineSize() {
		return uterineSize;
	}

	public void setUterineSize(String uterineSize) {
		this.uterineSize = uterineSize;
	}

	public String getEndometrialThickness() {
		return endometrialThickness;
	}

	public void setEndometrialThickness(String endometrialThickness) {
		this.endometrialThickness = endometrialThickness;
	}

	public String getOvaryRightSize() {
		return ovaryRightSize;
	}

	public void setOvaryRightSize(String ovaryRightSize) {
		this.ovaryRightSize = ovaryRightSize;
	}

	public String getOvaryLeftSize() {
		return ovaryLeftSize;
	}

	public void setOvaryLeftSize(String ovaryLeftSize) {
		this.ovaryLeftSize = ovaryLeftSize;
	}

	public Integer getAfcRight() {
		return afcRight;
	}

	public void setAfcRight(Integer afcRight) {
		this.afcRight = afcRight;
	}

	public Integer getAfcLeft() {
		return afcLeft;
	}

	public void setAfcLeft(Integer afcLeft) {
		this.afcLeft = afcLeft;
	}

	public String getFibroids() {
		return fibroids;
	}

	public void setFibroids(String fibroids) {
		this.fibroids = fibroids;
	}

	public String getCysts() {
		return cysts;
	}

	public void setCysts(String cysts) {
		this.cysts = cysts;
	}

	public String getPolyps() {
		return polyps;
	}

	public void setPolyps(String polyps) {
		this.polyps = polyps;
	}

	public String getHsgResult() {
		return hsgResult;
	}

	public void setHsgResult(String hsgResult) {
		this.hsgResult = hsgResult;
	}

	public String getTubalPatency() {
		return tubalPatency;
	}

	public void setTubalPatency(String tubalPatency) {
		this.tubalPatency = tubalPatency;
	}

	public String getBloodType() {
		return bloodType;
	}

	public void setBloodType(String bloodType) {
		this.bloodType = bloodType;
	}

	public String getRubella() {
		return rubella;
	}

	public void setRubella(String rubella) {
		this.rubella = rubella;
	}

	public String getHiv() {
		return hiv;
	}

	public void setHiv(String hiv) {
		this.hiv = hiv;
	}

	public String getHepatitisB() {
		return hepatitisB;
	}

	public void setHepatitisB(String hepatitisB) {
		this.hepatitisB = hepatitisB;
	}

	public String getHepatitisC() {
		return hepatitisC;
	}

	public void setHepatitisC(String hepatitisC) {
		this.hepatitisC = hepatitisC;
	}

	public String getSyphilis() {
		return syphilis;
	}

	public void setSyphilis(String syphilis) {
		this.syphilis = syphilis;
	}

	public Date getTestDate() {
		return testDate;
	}

	public void setTestDate(Date testDate) {
		this.testDate = testDate;
	}

	public String getPerformedBy() {
		return performedBy;
	}

	public void setPerformedBy(String performedBy) {
		this.performedBy = performedBy;
	}

	public String getLabName() {
		return labName;
	}

	public void setLabName(String labName) {
		this.labName = labName;
	}

	public String getOtherTestResults() {
		return otherTestResults;
	}

	public void setOtherTestResults(String otherTestResults) {
		this.otherTestResults = otherTestResults;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}
}
