package com.floreantpos.model.consultation;

import java.io.Serializable;

/**
 * Represents the "Pregnancy History" subsection for the female partner.
 * JSON Key: JSON_PROP_FEMALE_PREGNANCY_HISTORY
 */
public class FemalePregnancyHistory implements Serializable {
	private static final long serialVersionUID = 1L;

	private Integer totalPregnancies;
	private Integer liveBirths;
	private Integer miscarriages;
	private Integer ectopicPregnancies;
	private Integer abortions;
	private Integer stillbirths;
	private String details; // Corresponds to 'pregnancy_details' textarea

	public FemalePregnancyHistory() {
	}

	// Getters and Setters
	public Integer getTotalPregnancies() {
		return totalPregnancies;
	}

	public void setTotalPregnancies(Integer totalPregnancies) {
		this.totalPregnancies = totalPregnancies;
	}

	public Integer getLiveBirths() {
		return liveBirths;
	}

	public void setLiveBirths(Integer liveBirths) {
		this.liveBirths = liveBirths;
	}

	public Integer getMiscarriages() {
		return miscarriages;
	}

	public void setMiscarriages(Integer miscarriages) {
		this.miscarriages = miscarriages;
	}

	public Integer getEctopicPregnancies() {
		return ectopicPregnancies;
	}

	public void setEctopicPregnancies(Integer ectopicPregnancies) {
		this.ectopicPregnancies = ectopicPregnancies;
	}

	public Integer getAbortions() {
		return abortions;
	}

	public void setAbortions(Integer abortions) {
		this.abortions = abortions;
	}

	public Integer getStillbirths() {
		return stillbirths;
	}

	public void setStillbirths(Integer stillbirths) {
		this.stillbirths = stillbirths;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}
}