package com.floreantpos.model.consultation;

/**
 * Enum representing the fertilization method used in IVF.
 */
public enum FertilizationMethod {
	//@formatter:off
	IVF("IVF", "In Vitro Fertilization - conventional insemination, sperm and eggs mixed in dish"),
	ICSI("ICSI", "Intracytoplasmic Sperm Injection - single sperm injected directly into egg"),
	PICSI("PICSI", "Physiological ICSI - sperm selected by hyaluronic acid binding before ICSI"),
	IMSI("IMSI", "Intracytoplasmic Morphologically Selected Sperm Injection - high magnification sperm selection"),
	IVI("IVI", "Intravaginal Insemination - sperm placed in vagina (not common in IVF)"),
	IUI("IUI", "Intrauterine Insemination - sperm placed directly in uterus (not IVF, but tracked)");
	//@formatter:on

	private final String displayName;
	private final String description;

	FertilizationMethod(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Check if this is a microinjection technique (ICSI-based)
	 */
	public boolean isMicroinjection() {
		return this == ICSI || this == PICSI || this == IMSI;
	}

	/**
	 * Check if this is conventional IVF (no injection)
	 */
	public boolean isConventional() {
		return this == IVF;
	}

	/**
	 * Check if this is an insemination method (not true IVF)
	 */
	public boolean isInsemination() {
		return this == IVI || this == IUI;
	}

	/**
	 * Check if this requires sperm selection/preparation
	 */
	public boolean requiresSpermSelection() {
		return this == PICSI || this == IMSI;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
