package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.List;

/**
 * A generic container for history sections that consist of a list of conditions and a details text field.
 * This can be reused for Gynecological, Medical, Surgical, and Family History sections.
 */
public class GenericHistory implements Serializable {
	private static final long serialVersionUID = 1L;

	private List<String> items; // The list of checked items
	private String details; // The free-text details field

	public GenericHistory() {
	}

	// Getters and Setters
	public List<String> getItems() {
		return items;
	}

	public void setItems(List<String> items) {
		this.items = items;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}
}

// NOTE: Instead of creating separate classes like FemaleGynecologicalCondition, FemaleMedicalHistory, etc.,
// you can simply use this GenericHistory POJO for all of them in your Couple class. For example:
//
// couple.setObjectProperty(JSON_PROP_FEMALE_GYN_CONDITIONS, genericHistoryObject);
// couple.setObjectProperty(JSON_PROP_FEMALE_MEDICAL_HISTORY, anotherGenericHistoryObject);
//
// This reduces the number of classes you need to create.