package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.Date;

/**
 * Represents the "Insurance & Financial" and "Consent" sections.
 * JSON Key: JSON_PROP_INSURANCE (for insurance part)
 * You might also create a separate Consent POJO.
 */
public class InsuranceAndConsent implements Serializable {
	private static final long serialVersionUID = 1L;

	// Insurance
	private Boolean hasInsurance;
	private String insuranceCompany;
	private String policyNumber;
	private String fertilityCoverage;
	private Boolean wantsFinancingInfo;

	// Genetic Screening
	private String geneticScreeningInterest;

	// Consent
	private Boolean infoAccuracyConsent;
	private Boolean privacyPolicyConsent;
	private Boolean contactConsent;
	private String femaleSignature;
	private Date femaleSignatureDate;
	private String maleSignature;
	private Date maleSignatureDate;

	public InsuranceAndConsent() {
	}

	// Getters and Setters
	public Boolean getHasInsurance() {
		return hasInsurance;
	}

	public void setHasInsurance(Boolean hasInsurance) {
		this.hasInsurance = hasInsurance;
	}

	public String getInsuranceCompany() {
		return insuranceCompany;
	}

	public void setInsuranceCompany(String insuranceCompany) {
		this.insuranceCompany = insuranceCompany;
	}

	public String getPolicyNumber() {
		return policyNumber;
	}

	public void setPolicyNumber(String policyNumber) {
		this.policyNumber = policyNumber;
	}

	public String getFertilityCoverage() {
		return fertilityCoverage;
	}

	public void setFertilityCoverage(String fertilityCoverage) {
		this.fertilityCoverage = fertilityCoverage;
	}

	public Boolean getWantsFinancingInfo() {
		return wantsFinancingInfo;
	}

	public void setWantsFinancingInfo(Boolean wantsFinancingInfo) {
		this.wantsFinancingInfo = wantsFinancingInfo;
	}

	public String getGeneticScreeningInterest() {
		return geneticScreeningInterest;
	}

	public void setGeneticScreeningInterest(String geneticScreeningInterest) {
		this.geneticScreeningInterest = geneticScreeningInterest;
	}

	public Boolean getInfoAccuracyConsent() {
		return infoAccuracyConsent;
	}

	public void setInfoAccuracyConsent(Boolean infoAccuracyConsent) {
		this.infoAccuracyConsent = infoAccuracyConsent;
	}

	public Boolean getPrivacyPolicyConsent() {
		return privacyPolicyConsent;
	}

	public void setPrivacyPolicyConsent(Boolean privacyPolicyConsent) {
		this.privacyPolicyConsent = privacyPolicyConsent;
	}

	public Boolean getContactConsent() {
		return contactConsent;
	}

	public void setContactConsent(Boolean contactConsent) {
		this.contactConsent = contactConsent;
	}

	public String getFemaleSignature() {
		return femaleSignature;
	}

	public void setFemaleSignature(String femaleSignature) {
		this.femaleSignature = femaleSignature;
	}

	public Date getFemaleSignatureDate() {
		return femaleSignatureDate;
	}

	public void setFemaleSignatureDate(Date femaleSignatureDate) {
		this.femaleSignatureDate = femaleSignatureDate;
	}

	public String getMaleSignature() {
		return maleSignature;
	}

	public void setMaleSignature(String maleSignature) {
		this.maleSignature = maleSignature;
	}

	public Date getMaleSignatureDate() {
		return maleSignatureDate;
	}

	public void setMaleSignatureDate(Date maleSignatureDate) {
		this.maleSignatureDate = maleSignatureDate;
	}
}