package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.List;

/**
 * Represents the "Lifestyle Factors" section for either partner.
 * JSON Keys: JSON_PROP_FEMALE_LIFESTYLE, JSON_PROP_MALE_LIFESTYLE
 */
public class LifestyleFactors implements Serializable {
	private static final long serialVersionUID = 1L;

	private Double heightCm;
	private Double weightKg;
	private Double bmi;
	private String smokingStatus;
	private String alcoholConsumption;
	private String exerciseFrequency;
	private String recreationalDrugUse;
	// Female-specific
	private String caffeineIntake;
	private Integer stressLevel;
	// Male-specific
	private List<String> occupationalExposures;
	private Boolean usesHotTubsOrSaunas;

	public LifestyleFactors() {
	}

	// Getters and Setters
	public Double getHeightCm() {
		return heightCm;
	}

	public void setHeightCm(Double heightCm) {
		this.heightCm = heightCm;
	}

	public Double getWeightKg() {
		return weightKg;
	}

	public void setWeightKg(Double weightKg) {
		this.weightKg = weightKg;
	}

	public Double getBmi() {
		return bmi;
	}

	public void setBmi(Double bmi) {
		this.bmi = bmi;
	}

	public String getSmokingStatus() {
		return smokingStatus;
	}

	public void setSmokingStatus(String smokingStatus) {
		this.smokingStatus = smokingStatus;
	}

	public String getAlcoholConsumption() {
		return alcoholConsumption;
	}

	public void setAlcoholConsumption(String alcoholConsumption) {
		this.alcoholConsumption = alcoholConsumption;
	}

	public String getExerciseFrequency() {
		return exerciseFrequency;
	}

	public void setExerciseFrequency(String exerciseFrequency) {
		this.exerciseFrequency = exerciseFrequency;
	}

	public String getRecreationalDrugUse() {
		return recreationalDrugUse;
	}

	public void setRecreationalDrugUse(String recreationalDrugUse) {
		this.recreationalDrugUse = recreationalDrugUse;
	}

	public String getCaffeineIntake() {
		return caffeineIntake;
	}

	public void setCaffeineIntake(String caffeineIntake) {
		this.caffeineIntake = caffeineIntake;
	}

	public Integer getStressLevel() {
		return stressLevel;
	}

	public void setStressLevel(Integer stressLevel) {
		this.stressLevel = stressLevel;
	}

	public List<String> getOccupationalExposures() {
		return occupationalExposures;
	}

	public void setOccupationalExposures(List<String> occupationalExposures) {
		this.occupationalExposures = occupationalExposures;
	}

	public Boolean getUsesHotTubsOrSaunas() {
		return usesHotTubsOrSaunas;
	}

	public void setUsesHotTubsOrSaunas(Boolean usesHotTubsOrSaunas) {
		this.usesHotTubsOrSaunas = usesHotTubsOrSaunas;
	}
}