package com.floreantpos.model.consultation;

import java.io.Serializable;
import java.util.Date;

/**
 * Represents male initial fertility workup data including semen analysis results.
 * This is a non-persistent POJO stored as JSON within Couple entity.
 */
public class MaleInitialWorkup implements Serializable {
	private static final long serialVersionUID = 1L;

	// Semen Analysis Parameters
	private String spermCount; // e.g., "15 million/ml"
	private String motility; // e.g., "60% progressive"
	private String morphology; // e.g., "4% normal forms"
	private String volume; // e.g., "2.5 ml"
	private Double pH; // Normal: 7.2-8.0
	private String liquefactionTime; // e.g., "20 minutes"

	// Additional parameters
	private String viscosity; // Normal, High, Low
	private String appearance; // Normal, Abnormal
	private String concentration; // Sperm concentration
	private String totalSpermCount; // Total count in entire ejaculate
	private String progressiveMotility; // Percentage
	private String nonProgressiveMotility; // Percentage
	private String immotile; // Percentage

	// Test metadata
	private Date testDate;
	private String performedBy; // Lab or technician name
	private String labName; // Laboratory name

	// Clinical notes
	private String note;

	public MaleInitialWorkup() {
	}

	// Getters and Setters

	public String getSpermCount() {
		return spermCount;
	}

	public void setSpermCount(String spermCount) {
		this.spermCount = spermCount;
	}

	public String getMotility() {
		return motility;
	}

	public void setMotility(String motility) {
		this.motility = motility;
	}

	public String getMorphology() {
		return morphology;
	}

	public void setMorphology(String morphology) {
		this.morphology = morphology;
	}

	public String getVolume() {
		return volume;
	}

	public void setVolume(String volume) {
		this.volume = volume;
	}

	public Double getpH() {
		return pH;
	}

	public void setpH(Double pH) {
		this.pH = pH;
	}

	public String getLiquefactionTime() {
		return liquefactionTime;
	}

	public void setLiquefactionTime(String liquefactionTime) {
		this.liquefactionTime = liquefactionTime;
	}

	public String getViscosity() {
		return viscosity;
	}

	public void setViscosity(String viscosity) {
		this.viscosity = viscosity;
	}

	public String getAppearance() {
		return appearance;
	}

	public void setAppearance(String appearance) {
		this.appearance = appearance;
	}

	public String getConcentration() {
		return concentration;
	}

	public void setConcentration(String concentration) {
		this.concentration = concentration;
	}

	public String getTotalSpermCount() {
		return totalSpermCount;
	}

	public void setTotalSpermCount(String totalSpermCount) {
		this.totalSpermCount = totalSpermCount;
	}

	public String getProgressiveMotility() {
		return progressiveMotility;
	}

	public void setProgressiveMotility(String progressiveMotility) {
		this.progressiveMotility = progressiveMotility;
	}

	public String getNonProgressiveMotility() {
		return nonProgressiveMotility;
	}

	public void setNonProgressiveMotility(String nonProgressiveMotility) {
		this.nonProgressiveMotility = nonProgressiveMotility;
	}

	public String getImmotile() {
		return immotile;
	}

	public void setImmotile(String immotile) {
		this.immotile = immotile;
	}

	public Date getTestDate() {
		return testDate;
	}

	public void setTestDate(Date testDate) {
		this.testDate = testDate;
	}

	public String getPerformedBy() {
		return performedBy;
	}

	public void setPerformedBy(String performedBy) {
		this.performedBy = performedBy;
	}

	public String getLabName() {
		return labName;
	}

	public void setLabName(String labName) {
		this.labName = labName;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}
}
