package com.floreantpos.model.consultation;

import java.io.Serializable;

/**
 * Represents the "Current Medications & Supplements" subsection.
 * JSON Keys: JSON_PROP_FEMALE_MEDICATIONS, JSON_PROP_MALE_MEDICATIONS
 */
public class MedicationHistory implements Serializable {
	private static final long serialVersionUID = 1L;

	private Boolean isTakingMedications;
	private String medicationList;
	// Female-specific
	private Boolean isTakingPrenatalVitamins;
	// Male-specific
	private String steroidUse; // e.g., "yes", "no", "past"

	public MedicationHistory() {
	}

	// Getters and Setters
	public Boolean getIsTakingMedications() {
		return isTakingMedications;
	}

	public void setIsTakingMedications(Boolean isTakingMedications) {
		this.isTakingMedications = isTakingMedications;
	}

	public String getMedicationList() {
		return medicationList;
	}

	public void setMedicationList(String medicationList) {
		this.medicationList = medicationList;
	}

	public Boolean getIsTakingPrenatalVitamins() {
		return isTakingPrenatalVitamins;
	}

	public void setIsTakingPrenatalVitamins(Boolean isTakingPrenatalVitamins) {
		this.isTakingPrenatalVitamins = isTakingPrenatalVitamins;
	}

	public String getSteroidUse() {
		return steroidUse;
	}

	public void setSteroidUse(String steroidUse) {
		this.steroidUse = steroidUse;
	}
}