package com.floreantpos.model.consultation;

/**
 * Enum representing the status of a ProtocolPhase during cycle execution.
 */
public enum PhaseStatus {
	//@formatter:off
	PENDING("Pending", "Phase has not started yet"),
	IN_PROGRESS("In Progress", "Phase is currently active"),
	COMPLETED("Completed", "Phase has been completed successfully"),
	SKIPPED("Skipped", "Phase was skipped or not applicable"),
	CANCELLED("Cancelled", "Phase was cancelled before completion");
	//@formatter:on

	private final String displayName;
	private final String description;

	PhaseStatus(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Check if the phase is currently active
	 */
	public boolean isActive() {
		return this == IN_PROGRESS;
	}

	/**
	 * Check if the phase is finished (completed or not)
	 */
	public boolean isFinished() {
		return this == COMPLETED || this == SKIPPED || this == CANCELLED;
	}

	/**
	 * Check if the phase was completed successfully
	 */
	public boolean isCompleted() {
		return this == COMPLETED;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
