package com.floreantpos.model.consultation;

import java.io.Serializable;

/**
 * Represents a single medication prescribed within a specific phase of an IVF protocol.
 * 
 * This is a non-persistent Plain Old Java Object (POJO), intended to be part of a list
 * within a ProtocolPhase object. It holds the template information for a medication,
 * which can then be customized in a patient-specific Cycle Plan.
 */
public class ProtocolMedication implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * The name of the medication.
	 * Example: "Gonal-F", "Menopur", "Ovidrel", "Progesterone in Oil"
	 */
	private String medicationName;

	/**
	 * The prescribed dosage. This is a String to accommodate various units and ranges.
	 * Example: "150 IU", "75-150 IU", "250 mcg", "1 mL"
	 */
	private String dosage;

	/**
	 * How often the medication should be administered.
	 * Example: "Daily, in the evening", "Twice a day", "Once, at a specific time"
	 */
	private String frequency;

	/**
	 * Additional instructions for administration, such as the route.
	 * Example: "Subcutaneous injection into the abdomen", "Intramuscular injection", "Take with food"
	 */
	private String instructions;

	/**
	 * Default no-argument constructor, required for serialization/deserialization frameworks like Gson.
	 */
	public ProtocolMedication() {
	}

	//<editor-fold desc="Getters and Setters">

	public String getMedicationName() {
		return medicationName;
	}

	public void setMedicationName(String medicationName) {
		this.medicationName = medicationName;
	}

	public String getDosage() {
		return dosage;
	}

	public void setDosage(String dosage) {
		this.dosage = dosage;
	}

	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	public String getInstructions() {
		return instructions;
	}

	public void setInstructions(String instructions) {
		this.instructions = instructions;
	}

	//</editor-fold>
}