package com.floreantpos.model.consultation;

import java.io.Serializable;

/**
 * Represents a single monitoring task (e.g., ultrasound, bloodwork) scheduled 
 * within a specific phase of an IVF protocol.
 * 
 * This is a non-persistent Plain Old Java Object (POJO), intended to be part of a list
 * within a ProtocolPhase object. It holds the template information for a clinical task,
 * which is then used to schedule actual appointments in a patient's Cycle Plan.
 */
public class ProtocolMonitoringTask implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * The name of the monitoring task.
	 * Example: "Baseline Ultrasound", "Follicle Monitoring", "Beta hCG Pregnancy Test"
	 */
	private String taskName;

	/**
	 * The typical schedule for this task, often relative to the cycle's progression.
	 * Example: "Cycle Day 2-3", "Stimulation Day 5, 7, and 9", "9-11 days post-transfer"
	 */
	private String schedule;

	/**
	 * Specific instructions or goals for what should be checked during this task.
	 * Example: "Measure follicle sizes and endometrial lining.", "Check E2, LH, Progesterone levels."
	 */
	private String details;

	/**
	 * Default no-argument constructor, required for serialization/deserialization frameworks like Gson.
	 */
	public ProtocolMonitoringTask() {
	}

	//<editor-fold desc="Getters and Setters">

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getSchedule() {
		return schedule;
	}

	public void setSchedule(String schedule) {
		this.schedule = schedule;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	//</editor-fold>
}