package com.floreantpos.model.consultation; 

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents a single, distinct phase within an IVF protocol template 
 * (e.g., "Ovarian Stimulation", "Ovulation Trigger", "Luteal Phase Support").
 * 
 * This is a non-persistent Plain Old Java Object (POJO), designed to be 
 * part of a list that is serialized into a JSON string and stored in a parent entity
 * like ProtocolTemplate or TreatmentCycle.
 */
public class ProtocolPhaseTemplete implements Serializable {
	private static final long serialVersionUID = 1L;

	private String phaseName;
	private String description;
	private Integer estimatedStartDay;
	private Integer estimatedDurationDays;
	private Integer sortOrder;

	private List<ProtocolMedication> medications = new ArrayList<>();
	private List<ProtocolMonitoringTask> monitoringTasks = new ArrayList<>();
	
	public ProtocolPhaseTemplete() {
	}


	public String getPhaseName() {
		return phaseName;
	}

	public void setPhaseName(String phaseName) {
		this.phaseName = phaseName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getEstimatedDurationDays() {
		return estimatedDurationDays;
	}

	public void setEstimatedDurationDays(Integer estimatedDurationDays) {
		this.estimatedDurationDays = estimatedDurationDays;
	}

	public List<ProtocolMedication> getMedications() {
		return medications;
	}

	public void setMedications(List<ProtocolMedication> medications) {
		this.medications = medications;
	}

	public Integer getEstimatedStartDay() {
		return estimatedStartDay;
	}


	public void setEstimatedStartDay(Integer estimatedStartDay) {
		this.estimatedStartDay = estimatedStartDay;
	}


	public List<ProtocolMonitoringTask> getMonitoringTasks() {
		return monitoringTasks;
	}

	public void setMonitoringTasks(List<ProtocolMonitoringTask> monitoringTasks) {
		this.monitoringTasks = monitoringTasks;
	}


	public Integer getSortOrder() {
		return sortOrder;
	}


	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}

}