package com.floreantpos.model.consultation;

/**
 * Enum representing the method used to collect sperm sample.
 */
public enum SpermCollectionMethod {
	//@formatter:off
	MASTURBATION("Masturbation", "Standard collection via masturbation"),
	TESE("TESE", "Testicular Sperm Extraction - surgical extraction from testis"),
	MICRO_TESE("Micro-TESE", "Microsurgical Testicular Sperm Extraction"),
	PESA("PESA", "Percutaneous Epididymal Sperm Aspiration"),
	MESA("MESA", "Microsurgical Epididymal Sperm Aspiration"),
	ELECTROEJACULATION("Electroejaculation", "Electrically induced ejaculation for spinal cord injury patients"),
	DONOR_FROZEN("Donor Frozen", "Pre-frozen donor sperm from sperm bank");
	//@formatter:on

	private final String displayName;
	private final String description;

	SpermCollectionMethod(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Check if this is a surgical extraction method
	 */
	public boolean isSurgical() {
		return this == TESE || this == MICRO_TESE || this == PESA || this == MESA;
	}

	/**
	 * Check if this is standard non-invasive collection
	 */
	public boolean isNonInvasive() {
		return this == MASTURBATION || this == DONOR_FROZEN;
	}

	/**
	 * Check if this is testicular extraction (vs epididymal)
	 */
	public boolean isTesticular() {
		return this == TESE || this == MICRO_TESE;
	}

	/**
	 * Check if this is epididymal extraction
	 */
	public boolean isEpididymal() {
		return this == PESA || this == MESA;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
