package com.floreantpos.model.consultation;

/**
 * Enum representing the method used to process/prepare sperm for fertilization.
 */
public enum SpermProcessingMethod {
	//@formatter:off
	NONE("None", "No processing - used as is (rare)"),
	SIMPLE_WASH("Simple Wash", "Basic washing with culture medium"),
	SWIM_UP("Swim-Up", "Motile sperm swim up into culture medium - selects most motile sperm"),
	DENSITY_GRADIENT("Density Gradient", "Gradient centrifugation (Percoll/Isolate) - most common method"),
	DOUBLE_WASH("Double Wash", "Two-step washing process"),
	ZETA_METHOD("Zeta Method", "Electrostatic sperm selection based on surface charge"),
	MACS("MACS", "Magnetic Activated Cell Sorting - removes apoptotic sperm"),
	PICSI_PREP("PICSI Preparation", "Hyaluronic acid binding dish preparation for PICSI");
	//@formatter:on

	private final String displayName;
	private final String description;

	SpermProcessingMethod(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Check if this method selects based on motility
	 */
	public boolean isMotilityBased() {
		return this == SWIM_UP || this == DENSITY_GRADIENT;
	}

	/**
	 * Check if this is an advanced selection method
	 */
	public boolean isAdvanced() {
		return this == ZETA_METHOD || this == MACS || this == PICSI_PREP;
	}

	/**
	 * Check if this is a basic washing method
	 */
	public boolean isBasicWash() {
		return this == SIMPLE_WASH || this == DOUBLE_WASH;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
