package com.floreantpos.model.consultation;

/**
 * Enum representing the source of sperm used in IVF cycle.
 */
public enum SpermSource {
	//@formatter:off
	PARTNER("Partner", "Sperm from male partner in the couple"),
	DONOR("Donor", "Sperm from anonymous or known donor"),
	DONOR_BANK("Donor Bank", "Sperm purchased from commercial sperm bank");
	//@formatter:on

	private final String displayName;
	private final String description;

	SpermSource(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Check if this is partner sperm
	 */
	public boolean isPartner() {
		return this == PARTNER;
	}

	/**
	 * Check if this is donor sperm (any type)
	 */
	public boolean isDonor() {
		return this == DONOR || this == DONOR_BANK;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
