package com.floreantpos.model.consultation;

/**
 * Enum representing the type of embryo transfer.
 */
public enum TransferType {
	//@formatter:off
	FRESH("Fresh Transfer", "Fresh embryo transfer from current cycle"),
	FET("Frozen Embryo Transfer", "Frozen embryo transfer (FET) from previous cycle or donor"),
	DONOR_FRESH("Donor Fresh", "Fresh transfer using donor eggs/embryos"),
	DONOR_FROZEN("Donor Frozen", "Frozen transfer using donor eggs/embryos");
	//@formatter:on

	private final String displayName;
	private final String description;

	TransferType(String displayName, String description) {
		this.displayName = displayName;
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Check if this is a fresh (non-frozen) transfer
	 */
	public boolean isFresh() {
		return this == FRESH || this == DONOR_FRESH;
	}

	/**
	 * Check if this is a frozen embryo transfer
	 */
	public boolean isFrozen() {
		return this == FET || this == DONOR_FROZEN;
	}

	/**
	 * Check if this involves donor eggs/embryos
	 */
	public boolean isDonor() {
		return this == DONOR_FRESH || this == DONOR_FROZEN;
	}

	/**
	 * Check if this is from patient's own eggs
	 */
	public boolean isAutologous() {
		return this == FRESH || this == FET;
	}

	@Override
	public String toString() {
		return displayName;
	}
}
