package com.floreantpos.model.dao;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Couple;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Patient;
import com.floreantpos.swing.PaginationSupport;

public class CoupleDAO extends BaseCoupleDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public CoupleDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		Serializable serializable = super.save(obj, s);
		return serializable;
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session session) throws HibernateException {
		Couple couple = (Couple) obj;
		if (couple == null) {
			throw new PosException(Messages.getString("MenuItemDAO.0")); //$NON-NLS-1$
		}

		couple.setDeleted(true);

		session.update(couple);
	}

	private void doCheckValidation(Object obj) {
		Couple couple = (Couple) obj;
	}

	public void findByPhoneOrName(String searchString, PaginationSupport tableModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Couple.class);

			addDeletedFilter(criteria);

			if (StringUtils.isNotEmpty(searchString)) {
				DetachedCriteria dPatientCriteria = DetachedCriteria.forClass(Patient.class);
				dPatientCriteria.add(Restrictions.or(Restrictions.ilike(Customer.PROP_NAME, searchString, MatchMode.ANYWHERE),
						Restrictions.ilike(Customer.PROP_MOBILE_NO, searchString, MatchMode.ANYWHERE),
						Restrictions.ilike(Customer.PROP_LOYALTY_NO, searchString, MatchMode.ANYWHERE)));
				dPatientCriteria.setProjection(Projections.id());

				criteria.add(Restrictions.or(Subqueries.propertyIn(Couple.PROP_MALE_PARTNER_ID, dPatientCriteria),
						Subqueries.propertyIn(Couple.PROP_FEMALE_PARTNER_ID, dPatientCriteria)));
			}

			tableModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.desc(Couple.PROP_CREATED_DATE));
			tableModel.setRows(criteria.list());
		}
	}
}