package com.floreantpos.model.dao;

import java.io.Serializable;

import org.hibernate.HibernateException;
import org.hibernate.Session;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ProtocolPhase;

public class ProtocolPhaseDAO extends BaseProtocolPhaseDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ProtocolPhaseDAO () {}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		Serializable serializable = super.save(obj, s);
		return serializable;
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session session) throws HibernateException {
		ProtocolPhase protocolPhase = (ProtocolPhase) obj;
		if (protocolPhase == null) {
			throw new PosException(Messages.getString("MenuItemDAO.0")); //$NON-NLS-1$
		}

		protocolPhase.setDeleted(true);

		session.update(protocolPhase);
	}

	private void doCheckValidation(Object obj) {
		ProtocolPhase protocolPhase = (ProtocolPhase) obj;
		// Add validation logic here if needed
	}

	/**
	 * Initialize lazy-loaded collections for a ProtocolPhase
	 */
	public void initializeProtocolPhase(ProtocolPhase protocolPhase, Session session) {
		if (protocolPhase == null) {
			return;
		}

		// Initialize the CyclePlan relationship
		if (protocolPhase.getCyclePlan() != null) {
			org.hibernate.Hibernate.initialize(protocolPhase.getCyclePlan());
		}

		// Initialize the CycleStageLogs collection
		if (protocolPhase.getCycleStageLogs() != null) {
			org.hibernate.Hibernate.initialize(protocolPhase.getCycleStageLogs());
		}
	}

	/**
	 * Load full protocol phase with all lazy collections initialized
	 */
	public ProtocolPhase loadFullProtocolPhase(String protocolPhaseId) {
		Session session = null;
		try {
			session = createNewSession();
			ProtocolPhase protocolPhase = (ProtocolPhase) get(ProtocolPhase.class, protocolPhaseId, session);
			if (protocolPhase != null) {
				initializeProtocolPhase(protocolPhase, session);
			}
			return protocolPhase;
		} finally {
			if (session != null) {
				session.close();
			}
		}
	}

	/**
	 * Load full protocol phase with all lazy collections initialized (for existing object)
	 */
	public ProtocolPhase loadFullProtocolPhase(ProtocolPhase protocolPhase) {
		Session session = null;
		try {
			session = createNewSession();
			session.refresh(protocolPhase);
			initializeProtocolPhase(protocolPhase, session);
			return protocolPhase;
		} finally {
			if (session != null) {
				session.close();
			}
		}
	}

}