package com.floreantpos.model.dao;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ProtocolTemplate;
import com.floreantpos.swing.PaginationSupport;

public class ProtocolTemplateDAO extends BaseProtocolTemplateDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ProtocolTemplateDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		Serializable serializable = super.save(obj, s);
		return serializable;
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		doCheckValidation(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session session) throws HibernateException {
		ProtocolTemplate protocolTemplate = (ProtocolTemplate) obj;
		if (protocolTemplate == null) {
			throw new PosException(Messages.getString("MenuItemDAO.0")); //$NON-NLS-1$
		}

		protocolTemplate.setDeleted(true);

		session.update(protocolTemplate);
	}

	private void doCheckValidation(Object obj) {
		ProtocolTemplate protocolTemplate = (ProtocolTemplate) obj;

	}

	public void findByPhoneOrName(String searchString, PaginationSupport tableModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(ProtocolTemplate.class);

			addDeletedFilter(criteria);

			if (StringUtils.isNotEmpty(searchString)) {
				criteria.add(Restrictions.ilike(ProtocolTemplate.PROP_NAME, searchString));
			}

			tableModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.asc(ProtocolTemplate.PROP_NAME));
			tableModel.setRows(criteria.list());
		}
	}
}