package com.floreantpos.report;

import java.io.Serializable;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.ReferralCommissionType;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;

public class ItemwiseRfReportData implements Serializable {
	private final String TOTAL = "Total";

	private String id;
	private String orderId;
	private String orderDate;
	private String outletId;

	private double rfOnNetSales;
	private double labDoctorFee;

	private double net;
	private String rfOnNetPercentageType;
	private String rfOnNetPercentage;
	private double finalNet;

	private String itemName;
	private double itemPrice;
	private double itemDiscount;
	private double itemTax;
	private double rfPercentage;
	private String rfPercentageType;
	private Boolean isApplyDiscountOnRF;
	private double rf;
	private double nonRf;

	public ItemwiseRfReportData() {

	}

	//	public ItemwiseRfReportData(Ticket ticket, TicketItem ticketItem) {
	//		populateTicketItemData(ticketItem);
	//		populateTicketData(ticket);
	//	}

	public void populateTicketData(Ticket ticket) {
		double subtotalAmount = ticket.getSubtotalAmount() - ticket.getDiscountAmount();
		setItemName(getBoldText(TOTAL));
		setOrderDate(DateUtil.formatAsShortDate(DateUtil.convertServerTimeToBrowserTime(ticket.getCreateDate())));
		setOutletId(ticket.getOutletId());
		setLabDoctorFee(ticket.getLabDoctorFee());

		setItemPrice(subtotalAmount);
		setItemDiscount(ticket.getDiscountAmount());
		setItemTax(ticket.getTaxAmount());

		setRf(ticket.getReferrerFeeOnReport());
		setNonRf(subtotalAmount);

		setRfOnNetPercentageType(ticket.getRfOnNetSalesType());
		setRfOnNetPercentage(ticket.getRfRateOnNetSales());

		double commissionOnReport = ticket.getReferrerFeeOnReport();
		double commissionOnNetSales = ticket.getReferrerFeeOnNetSales();
		setRfOnNetSales(commissionOnNetSales);

		//double nonRf = subtotalAmount - commissionOnReport;
		double nonRf = 0;
		if (ticket.isApplyDiscountOnReferral()) {
			nonRf = subtotalAmount - itemDiscount - commissionOnReport;
		}
		else {
			nonRf = subtotalAmount - commissionOnReport;
		}
		setNonRf(nonRf);
		double net = nonRf - ticket.getLabDoctorFee();
		setNet(net);

		double finalNet = net - commissionOnNetSales;
		setFinalNet(finalNet);

	}

	public void populateTicketItemData(TicketItem ticketItem) {
		setItemName(ticketItem.getNameDisplay());
		double itemPrice = ticketItem.getSubtotalAmount();
		setItemPrice(itemPrice);
		setItemDiscount(ticketItem.getAdjustedDiscount());
		setItemTax(ticketItem.getTaxAmount());
		setRfPercentageType(ticketItem.getRfOnReportType());
		setRfPercentage(ticketItem.getRfRateOnReport());
		setApplyDiscountOnRF(ticketItem.getTicket().isApplyDiscountOnReferral());
		setRf(ticketItem.getReferrerFeeOnReport());
		setRfOnNetSales(ticketItem.getReferrerFeeOnNetSales());
		//double nonRf = itemPrice - ticketItem.getReferrerFeeOnReport();
		double nonRf = 0;
		double totalRF = ticketItem.getReferrerFeeOnReport() + ticketItem.getReferrerFeeOnNetSales();
		if (isApplyDiscountOnRF()) {
			nonRf = itemPrice - ticketItem.getAdjustedDiscount() - totalRF;
		}
		else {
			nonRf = itemPrice - totalRF;
		}
		setNonRf(nonRf);
		setNet(nonRf - ticketItem.getLabDoctorFee());
		setLabDoctorFee(ticketItem.getLabDoctorFeeIncludingComboItem());
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public double getRfOnNetSales() {
		return rfOnNetSales;
	}

	public void setRfOnNetSales(double rfOnNetSales) {
		this.rfOnNetSales = rfOnNetSales;
	}

	public double getLabDoctorFee() {
		return labDoctorFee;
	}

	public void setLabDoctorFee(double labDoctorFee) {
		this.labDoctorFee = labDoctorFee;
	}

	public String getDisplayItemName() {
		return getItemName().startsWith("<strong") ? ReportUtil.getBoldText(getItemName(), 8) : getItemName();
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String id) {
		this.orderId = id;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public double getItemPrice() {
		return itemPrice;
	}

	public void setItemPrice(double itemPrice) {
		this.itemPrice = itemPrice;
	}

	public double getItemDiscount() {
		return itemDiscount;
	}

	public void setItemDiscount(double itemDiscount) {
		this.itemDiscount = itemDiscount;
	}

	public double getItemTax() {
		return itemTax;
	}

	public void setItemTax(double itemTax) {
		this.itemTax = itemTax;
	}

	public double getRfPercentage() {
		return rfPercentage;
	}

	public void setRfPercentage(double rfPercentage) {
		this.rfPercentage = rfPercentage;
	}

	public String getRfPercentageType() {
		return rfPercentageType;
	}

	public void setRfPercentageType(String rfPercentageType) {
		this.rfPercentageType = rfPercentageType;
	}

	public Boolean isApplyDiscountOnRF() {
		return isApplyDiscountOnRF;
	}

	public void setApplyDiscountOnRF(Boolean isApplyDiscountOnRF) {
		this.isApplyDiscountOnRF = isApplyDiscountOnRF;
	}

	public double getRf() {
		return rf;
	}

	public void setRf(double rf) {
		this.rf = rf;
	}

	public double getNonRf() {
		return nonRf;
	}

	public void setNonRf(double nonRf) {
		this.nonRf = nonRf;
	}

	public double getNet() {
		return net;
	}

	public void setNet(double net) {
		this.net = net;
	}

	public String getRfOnNetPercentageType() {
		return rfOnNetPercentageType;
	}

	public void setRfOnNetPercentageType(String rfOnNetPercentageType) {
		this.rfOnNetPercentageType = rfOnNetPercentageType;
	}

	public String getRfOnNetPercentage() {
		return rfOnNetPercentage;
	}

	public void setRfOnNetPercentage(String rfOnNetPercentage) {
		this.rfOnNetPercentage = rfOnNetPercentage;
	}

	public double getFinalNet() {
		return finalNet;
	}

	public void setFinalNet(double finalNet) {
		this.finalNet = finalNet;
	}

	public String getRfOnNetDisplay() {

		double rfOnNetPercentage = POSUtil.parseDouble(getRfOnNetPercentage());
		if (NumberUtil.isZero(rfOnNetPercentage)) {
			return "";
		}

		ReferralCommissionType chargeType = ReferralCommissionType.fromName(getRfOnNetPercentageType());
		if (chargeType == ReferralCommissionType.PERCENTAGE) {
			return NumberUtil.formatNumberIfNeeded(rfOnNetPercentage) + "%";
		}
		return NumberUtil.formatAmount(rfOnNetPercentage);
	}

	public String getRfDisplayName() {
		double rfPercentage = getRfPercentage();
		if (NumberUtil.isZero(rfPercentage)) {
			return "";
		}
		ReferralCommissionType chargeType = ReferralCommissionType.fromName(getRfPercentageType());
		if (chargeType == ReferralCommissionType.PERCENTAGE || chargeType == ReferralCommissionType.STANDARD) {
			return NumberUtil.formatNumberIfNeeded(rfPercentage) + "%";
		}
		return NumberUtil.formatAmount(rfPercentage);
	}

	public String getRfOnNetSalesDisplay() {
		double rfOnNetSales = getRfOnNetSales();
		if (NumberUtil.isZero(rfOnNetSales)) {
			return "";
		}
		return NumberUtil.formatAmount(rfOnNetSales);
	}

	public String getBoldText(String text) {
		StringBuilder builder = new StringBuilder();
		builder.append("<strong style=\"font-size:15px;\">"); //$NON-NLS-1$
		builder.append(text);
		builder.append("</strong>"); //$NON-NLS-1$
		return builder.toString();
	}

}
