package com.floreantpos.util;

import org.json.JSONObject;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class OrgJsonUtil {
	public static String getString(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return null;
		}

		return jsonObject.getString(key);
	}

	public static Boolean getBoolean(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return false;
		}

		return jsonObject.getBoolean(key);
	}

	public static Boolean getBoolean(JsonObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return false;
		}

		return jsonObject.get(key).getAsBoolean();
	}

	public static Boolean getBoolean(JsonObject jsonObject, String key, boolean defaultValue) {
		if (!jsonObject.has(key) || jsonObject.get(key).isJsonNull()) {
			return defaultValue;
		}

		return jsonObject.get(key).getAsBoolean();
	}

	public static Integer getInt(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0;
		}

		return jsonObject.getInt(key);
	}

	public static Integer getInt(JsonObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0;
		}

		return jsonObject.get(key).getAsInt();
	}

	public static Double getDouble(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0.0;
		}

		return jsonObject.getDouble(key);
	}

	public static Double getDouble(JsonObject jsonObject, String key) {
		if (jsonObject.has(key)) {
			return jsonObject.get(key).getAsDouble();
		}
		return 0D;
	}

	public static String getString(JsonObject jsonObject, String key) {
		if (jsonObject.has(key)) {
			JsonElement jsonElement = jsonObject.get(key);
			if (jsonElement.isJsonNull()) {
				return null;
			}
			return jsonElement.getAsString();
		}
		return null;
	}
}
