package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum RoomType {
	//@formatter:off
		CABIN("Private Room", "A single-patient room offering privacy and comfort."),
		SEMI_PRIVATE_ROOM("Semi-private room", "Shared by two patients, separated by a curtain."),
		WARD("General Ward", "A large room with multiple beds, shared by several patients."),
		ICU("ICU (Intensive Care Unit) Room", "Equipped for critical care, with advanced monitoring systems."),
		CCU("CCU (Coronary Care Unit) Room", "Specialized for cardiac patients."),
		HDU("HDU (High Dependency Unit) Room", "A step-down from ICU, for patients who require close monitoring but not full intensive care."),
		NICU("NICU (Neonatal Intensive Care Unit) Room", "Designed for premature or critically ill newborns."),
		PICU("PICU (Pediatric Intensive Care Unit) Room", "Specialized for critically ill children needing intensive care."),
		ISOLATION_ROOM("Isolation Room", "Used for patients with infectious diseases to prevent the spread of infections."),
		PEDIATRIC_ROOM("Pediatric Room", "Designed for children, often with colorful décor and parental accommodations."),
		MATERNITY_ROOM("Maternity Room", "Used for childbirth and postnatal care."),
		OPERATING_ROOM("Operating Room (OR)", "A sterile environment for surgical procedures."),
		RECOVER_ROOM("Recovery Room", "Where patients are monitored after surgery before moving to a regular room."),
		PSYCHIATRIC_ROOM("Psychiatric Room", "A secure environment for patients with mental health conditions."),
		VIP("VIP or Deluxe Room", "A premium room with additional amenities for comfort.")
		;
		//@formatter:on
	private String displayString;
	private String description;

	private RoomType(String displayString, String description) {
		this.displayString = displayString;
		this.description = description;
	}

	public static RoomType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return CABIN;
		}

		try {
			RoomType filter = valueOf(s.toUpperCase());
			return filter;
		} catch (Exception e) {
			return CABIN;
		}
	}

	public String getDisplayString() {
		return displayString;
	}

	public String getDescription() {
		return description;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

	public static boolean match(String src, RoomType target) {
		RoomType roomType = RoomType.fromString(src);
		return target == roomType;
	}
}
